/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private ProcessProperties properties = null;

    public ProcessElement() {
    }

    public ProcessElement(ProcessElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
        }
    }

    public ProcessElement(AssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            AssetProperties assetProperties = template.getProperties();
            if (assetProperties != null) {
                this.properties = new ProcessProperties(assetProperties);
            }
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public ProcessProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ProcessProperties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "ProcessElement{elementHeader=" + this.elementHeader + ", properties=" + this.properties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ProcessElement that = (ProcessElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties);
    }
}

