/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessProperties
extends AssetProperties {
    private static final long serialVersionUID = 1L;
    private static final String formulaProperty = "formula";
    private static final String formulaTypeProperty = "formulaType";
    private static final String implementationLanguageProperty = "implementationLanguage";
    private String formula = null;
    private String formulaType = null;
    private String implementationLanguage = null;

    public ProcessProperties() {
    }

    public ProcessProperties(ProcessProperties template) {
        super(template);
        if (template != null) {
            this.formula = template.getFormula();
            this.formulaType = template.getFormulaType();
            this.implementationLanguage = template.getImplementationLanguage();
        }
    }

    public ProcessProperties(AssetProperties template) {
        super(template);
        Map<String, Object> assetExtendedProperties;
        if (template != null && (assetExtendedProperties = template.getExtendedProperties()) != null) {
            if (assetExtendedProperties.get(formulaProperty) != null) {
                this.formula = assetExtendedProperties.get(formulaProperty).toString();
                assetExtendedProperties.remove(formulaProperty);
            }
            if (assetExtendedProperties.get(formulaTypeProperty) != null) {
                this.formulaType = assetExtendedProperties.get(formulaTypeProperty).toString();
                assetExtendedProperties.remove(formulaTypeProperty);
            }
            if (assetExtendedProperties.get(implementationLanguageProperty) != null) {
                this.implementationLanguage = assetExtendedProperties.get(implementationLanguageProperty).toString();
                assetExtendedProperties.remove(implementationLanguageProperty);
            }
            super.setExtendedProperties(assetExtendedProperties);
        }
    }

    public AssetProperties cloneToAsset() {
        AssetProperties assetProperties = super.cloneToAsset("Process");
        Map<String, Object> extendedProperties = assetProperties.getExtendedProperties();
        if (extendedProperties == null) {
            extendedProperties = new HashMap<String, Object>();
        }
        if (this.formula != null) {
            extendedProperties.put(formulaProperty, this.formula);
        }
        if (this.formulaType != null) {
            extendedProperties.put(formulaTypeProperty, this.formulaType);
        }
        if (this.implementationLanguage != null) {
            extendedProperties.put(implementationLanguageProperty, this.implementationLanguage);
        }
        if (!extendedProperties.isEmpty()) {
            assetProperties.setExtendedProperties(extendedProperties);
        }
        return assetProperties;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(String formulaType) {
        this.formulaType = formulaType;
    }

    public String getImplementationLanguage() {
        return this.implementationLanguage;
    }

    public void setImplementationLanguage(String implementationLanguage) {
        this.implementationLanguage = implementationLanguage;
    }

    @Override
    public String toString() {
        return "ProcessProperties{name='" + this.getName() + "', versionIdentifier='" + this.getVersionIdentifier() + "', displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", formula='" + this.formula + "', formulaType='" + this.formulaType + "', implementationLanguage='" + this.implementationLanguage + "', cloneToAsset=" + this.cloneToAsset() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ProcessProperties that = (ProcessProperties)objectToCompare;
        return Objects.equals(this.formula, that.formula) && Objects.equals(this.formulaType, that.formulaType) && Objects.equals(this.implementationLanguage, that.implementationLanguage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFormula(), this.getFormulaType(), this.getImplementationLanguage());
    }
}

