/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConfigurationItemProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionProperties
extends ConfigurationItemProperties {
    private String displayName = null;
    private String description = null;
    private String userId = null;
    private String encryptedPassword = null;
    private String clearPassword = null;
    private Map<String, Object> configurationProperties = null;
    private Map<String, String> securedProperties = null;

    public ConnectionProperties() {
    }

    public ConnectionProperties(ConnectionProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.userId = template.getUserId();
            this.clearPassword = template.getClearPassword();
            this.encryptedPassword = template.getEncryptedPassword();
            this.configurationProperties = template.getConfigurationProperties();
            this.securedProperties = template.getSecuredProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.configurationProperties == null) {
            return null;
        }
        if (this.configurationProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.configurationProperties);
    }

    public void setSecuredProperties(Map<String, String> securedProperties) {
        this.securedProperties = securedProperties;
    }

    public Map<String, String> getSecuredProperties() {
        if (this.securedProperties == null) {
            return null;
        }
        if (this.securedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.securedProperties);
    }

    @Override
    public String toString() {
        return "ConnectionProperties{displayName='" + this.displayName + "', description='" + this.description + "', userId='" + this.userId + "', encryptedPassword='" + this.encryptedPassword + "', clearPassword='" + this.clearPassword + "', configurationProperties=" + this.configurationProperties + ", securedProperties=" + this.securedProperties + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectionProperties that = (ConnectionProperties)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUserId(), that.getUserId()) && Objects.equals(this.getEncryptedPassword(), that.getEncryptedPassword()) && Objects.equals(this.getClearPassword(), that.getClearPassword()) && Objects.equals(this.getConfigurationProperties(), that.getConfigurationProperties()) && Objects.equals(this.getSecuredProperties(), that.getSecuredProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getUserId(), this.getEncryptedPassword(), this.getClearPassword(), this.getSecuredProperties(), this.getConfigurationProperties());
    }
}

