/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.HostProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareServerPlatformProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareServerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=HostProperties.class, name="HostProperties"), @JsonSubTypes.Type(value=SoftwareServerProperties.class, name="SoftwareServerProperties"), @JsonSubTypes.Type(value=SoftwareServerPlatformProperties.class, name="SoftwareServerPlatformProperties")})
public class ITInfrastructureProperties
extends AssetProperties {
    private static final String deployedImplementationTypeProperty = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
    private String deployedImplementationType = null;

    public ITInfrastructureProperties() {
    }

    public ITInfrastructureProperties(ITInfrastructureProperties template) {
        super(template);
        if (template != null) {
            this.deployedImplementationType = template.getDeployedImplementationType();
        }
    }

    public ITInfrastructureProperties(AssetProperties template) {
        super(template);
        Map<String, Object> assetExtendedProperties;
        if (template != null && (assetExtendedProperties = template.getExtendedProperties()) != null) {
            if (assetExtendedProperties.get(deployedImplementationTypeProperty) != null) {
                this.deployedImplementationType = assetExtendedProperties.get(deployedImplementationTypeProperty).toString();
                assetExtendedProperties.remove(deployedImplementationTypeProperty);
            }
            super.setExtendedProperties(assetExtendedProperties);
        }
    }

    @Override
    public AssetProperties cloneToAsset(String subTypeName) {
        AssetProperties assetProperties = super.cloneToAsset(subTypeName);
        Map<String, Object> assetExtendedProperties = assetProperties.getExtendedProperties();
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (this.deployedImplementationType != null) {
            assetExtendedProperties.put(deployedImplementationTypeProperty, this.deployedImplementationType);
        }
        if (!assetExtendedProperties.isEmpty()) {
            assetProperties.setExtendedProperties(assetExtendedProperties);
        }
        return assetProperties;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public void setDeployedImplementationType(String platformType) {
        this.deployedImplementationType = platformType;
    }

    @Override
    public String toString() {
        return "ITInfrastructureProperties{deployedImplementationType='" + this.deployedImplementationType + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SoftwareServerPlatformProperties that = (SoftwareServerPlatformProperties)objectToCompare;
        return Objects.equals(this.deployedImplementationType, that.getDeployedImplementationType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deployedImplementationType);
    }
}

