/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConfigurationItemRelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformDeploymentProperties
extends ConfigurationItemRelationshipProperties {
    private static final String deploymentTimePropertyName = "deploymentTime";
    private static final String deployerPropertyName = "deployer";
    private static final String platformDeploymentStatusPropertyName = "platformStatus";
    private Date deploymentTime = null;
    private String deployer = null;
    private OperationalStatus platformDeploymentStatus = null;

    public PlatformDeploymentProperties() {
    }

    public PlatformDeploymentProperties(PlatformDeploymentProperties template) {
        super(template);
        if (template != null) {
            this.deploymentTime = template.getDeploymentTime();
            this.deployer = template.getDeployer();
            this.platformDeploymentStatus = template.getPlatformDeploymentStatus();
        }
    }

    public Map<String, Object> cloneToMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        if (this.deploymentTime != null) {
            propertyMap.put(deploymentTimePropertyName, this.deploymentTime);
        }
        if (this.deployer != null) {
            propertyMap.put(deployerPropertyName, this.deployer);
        }
        if (this.platformDeploymentStatus != null) {
            propertyMap.put(platformDeploymentStatusPropertyName, this.platformDeploymentStatus.getOpenTypeOrdinal());
        }
        if (!propertyMap.isEmpty()) {
            propertyMap = null;
        }
        return propertyMap;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getDeployer() {
        return this.deployer;
    }

    public void setDeployer(String deployer) {
        this.deployer = deployer;
    }

    public OperationalStatus getPlatformDeploymentStatus() {
        return this.platformDeploymentStatus;
    }

    public void setPlatformDeploymentStatus(OperationalStatus platformDeploymentStatus) {
        this.platformDeploymentStatus = platformDeploymentStatus;
    }

    @Override
    public String toString() {
        return "PlatformDeploymentProperties{deploymentTime=" + this.deploymentTime + ", deployer='" + this.deployer + "', platformDeploymentStatus=" + this.platformDeploymentStatus + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PlatformDeploymentProperties that = (PlatformDeploymentProperties)objectToCompare;
        return Objects.equals(this.deploymentTime, that.deploymentTime) && Objects.equals(this.deployer, that.deployer) && this.platformDeploymentStatus == that.platformDeploymentStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deploymentTime, this.deployer, this.platformDeploymentStatus);
    }
}

