/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ProcessManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.AssetManagerClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ControlFlowProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.DataFlowProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.LineageMappingProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessCallProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EffectiveTimeMetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;

public class ProcessManagerClient
extends AssetManagerClientBase
implements ProcessManagerInterface {
    private static final String processEntityType = "Process";
    private static final String containmentTypePropertyName = "containmentType";
    private static final String processHierarchyRelationship = "ProcessHierarchy";
    private static final String businessSignificanceClassification = "BusinessSignificance";

    public ProcessManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ProcessManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ProcessManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ProcessManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ProcessManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createProcess(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, ProcessStatus processStatus, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        AssetProperties assetProperties = processProperties.cloneToAsset();
        ElementStatus initialStatus = null;
        if (processStatus != null) {
            initialStatus = processStatus.getElementStatus();
        }
        return super.createAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, assetProperties, initialStatus, "createProcess");
    }

    public String createProcessFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        return super.createAssetFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties, "createProcessFromTemplate");
    }

    public void updateProcess(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String processGUID, boolean isMergeUpdate, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        AssetProperties assetProperties = processProperties.cloneToAsset();
        super.updateAsset(userId, infrastructureManagerGUID, infrastructureManagerName, processGUID, isMergeUpdate, assetProperties, "updateProcess");
    }

    public void updateProcessStatus(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String processGUID, ProcessStatus processStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        String statusParameterName = "processStatus";
        this.invalidParameterHandler.validateObject((Object)processStatus, "processStatus", "updateProcessStatus");
        super.updateAssetStatus(userId, infrastructureManagerGUID, infrastructureManagerName, processEntityType, processGUID, processStatus.getElementStatus(), "updateProcessStatus");
    }

    public void setupProcessParent(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessParent";
        HashMap<String, Object> propertyMap = null;
        if (containmentType != null) {
            propertyMap = new HashMap<String, Object>();
            propertyMap.put(containmentTypePropertyName, containmentType);
        }
        super.setupRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, processEntityType, parentProcessGUID, processHierarchyRelationship, processEntityType, childProcessGUID, effectiveFrom, effectiveTo, propertyMap, "setupProcessParent");
    }

    public void clearProcessParent(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String parentProcessGUID, String childProcessGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessParent";
        super.clearRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, processEntityType, parentProcessGUID, processHierarchyRelationship, processEntityType, childProcessGUID, effectiveTime, "clearProcessParent");
    }

    public void publishProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishProcess";
        super.publishAsset(userId, processGUID, "publishProcess");
    }

    public void withdrawProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawProcess";
        super.withdrawAsset(userId, processGUID, "withdrawProcess");
    }

    public void removeProcess(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProcess";
        super.removeAsset(userId, infrastructureManagerGUID, infrastructureManagerName, processGUID, "removeProcess");
    }

    public List<ProcessElement> findProcesses(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findProcesses";
        return this.convertAssetElements(super.findAssets(userId, searchString, processEntityType, effectiveTime, startFrom, pageSize, "findProcesses"));
    }

    public List<ProcessElement> getProcessesByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessesByName";
        return this.convertAssetElements(super.getAssetsByName(userId, name, processEntityType, effectiveTime, startFrom, pageSize, "getProcessesByName"));
    }

    public List<ProcessElement> getProcessesForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getHostsForInfrastructureManager";
        return this.convertAssetElements(super.getAssetsForInfrastructureManager(userId, infrastructureManagerGUID, infrastructureManagerName, processEntityType, effectiveTime, startFrom, pageSize, "getHostsForInfrastructureManager"));
    }

    public ProcessElement getProcessByGUID(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessByGUID";
        return this.convertAssetElement(super.getAssetByGUID(userId, processEntityType, processGUID, null, "getProcessByGUID"));
    }

    public ProcessElement getProcessParent(String userId, String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessParent";
        List<RelatedAssetElement> results = super.getRelatedAssets(userId, processEntityType, processGUID, 2, processHierarchyRelationship, processEntityType, effectiveTime, 0, 0, "getProcessParent");
        if (results == null || results.isEmpty()) {
            return null;
        }
        RelatedAssetElement result = results.get(0);
        return this.convertAssetElement(result.getRelatedAsset());
    }

    public List<ProcessElement> getSubProcesses(String userId, String processGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessParent";
        List<RelatedAssetElement> results = super.getRelatedAssets(userId, processEntityType, processGUID, 2, processHierarchyRelationship, processEntityType, effectiveTime, startFrom, pageSize, "getProcessParent");
        if (results == null || results.isEmpty()) {
            return null;
        }
        ArrayList<ProcessElement> subProcesses = new ArrayList<ProcessElement>();
        for (RelatedAssetElement relatedAssetElement : results) {
            if (relatedAssetElement == null) continue;
            subProcesses.add(this.convertAssetElement(relatedAssetElement.getRelatedAsset()));
        }
        return subProcesses;
    }

    public void setBusinessSignificant(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String elementGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setBusinessSignificant";
        super.addClassification(userId, infrastructureManagerGUID, infrastructureManagerName, false, "Referenceable", elementGUID, businessSignificanceClassification, effectiveFrom, effectiveTo, null, "setBusinessSignificant");
    }

    public void clearBusinessSignificant(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearBusinessSignificant";
        super.clearClassification(userId, infrastructureManagerGUID, infrastructureManagerName, "Referenceable", elementGUID, businessSignificanceClassification, effectiveTime, "clearBusinessSignificant");
    }

    public String setupDataFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "setupDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "setupDataFlow");
        DataFlowRequestBody requestBody = new DataFlowRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/suppliers/{2}/consumers/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupDataFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataSupplierGUID, dataConsumerGUID, infrastructureManagerIsHome});
        return results.getGUID();
    }

    public DataFlowElement getDataFlow(String userId, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlow");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlow");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/suppliers/{2}/consumers/{3}/retrieve";
        DataFlowElementResponse restResult = this.restClient.callDataFlowPostRESTCall("getDataFlow", urlTemplate, requestBody, this.serverName, userId, dataSupplierGUID, dataConsumerGUID);
        return restResult.getElement();
    }

    public void updateDataFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String dataFlowGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "updateDataFlow");
        DataFlowRequestBody requestBody = new DataFlowRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/{2}/update";
        this.restClient.callVoidPostRESTCall("updateDataFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFlowGUID});
    }

    public void clearDataFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String dataFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataFlow";
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearDataFlow");
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", "clearDataFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/{2}/remove";
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("clearDataFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFlowGUID});
    }

    public List<DataFlowElement> getDataFlowConsumers(String userId, String dataSupplierGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowConsumers";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowConsumers");
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", "getDataFlowConsumers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/suppliers/{2}/consumers/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowConsumers", urlTemplate, requestBody, this.serverName, userId, dataSupplierGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<DataFlowElement> getDataFlowSuppliers(String userId, String dataConsumerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFlowSuppliers";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFlowSuppliers");
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", "getDataFlowSuppliers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/data-flows/consumers/{2}/suppliers/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        DataFlowElementsResponse restResult = this.restClient.callDataFlowsPostRESTCall("getDataFlowSuppliers", urlTemplate, requestBody, this.serverName, userId, dataConsumerGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public String setupControlFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String currentStepGUID, String nextStepGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "setupControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "setupControlFlow");
        ControlFlowRequestBody requestBody = new ControlFlowRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/current-steps/{2}/next-steps/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupControlFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, currentStepGUID, nextStepGUID, infrastructureManagerIsHome});
        return results.getGUID();
    }

    public ControlFlowElement getControlFlow(String userId, String currentStepGUID, String nextStepGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlow";
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlow");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlow");
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", "getControlFlow");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/current-steps/{2}/next-steps/{3}/retrieve";
        ControlFlowElementResponse restResult = this.restClient.callControlFlowPostRESTCall("getControlFlow", urlTemplate, requestBody, this.serverName, userId, currentStepGUID, nextStepGUID);
        return restResult.getElement();
    }

    public void updateControlFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String controlFlowGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "updateControlFlow");
        ControlFlowRequestBody requestBody = new ControlFlowRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/{2}/update";
        this.restClient.callVoidPostRESTCall("updateControlFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, controlFlowGUID});
    }

    public void clearControlFlow(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String controlFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearControlFlow";
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearControlFlow");
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", "clearControlFlow");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/{2}/remove";
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("clearControlFlow", urlTemplate, requestBody, new Object[]{this.serverName, userId, controlFlowGUID});
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String userId, String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowNextSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowNextSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowNextSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/current-steps/{2}/next-steps/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowNextSteps", urlTemplate, requestBody, this.serverName, userId, currentStepGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String userId, String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getControlFlowPreviousSteps";
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, "getControlFlowPreviousSteps");
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", "getControlFlowPreviousSteps");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/control-flows/current-steps/{2}/previous-steps/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        ControlFlowElementsResponse restResult = this.restClient.callControlFlowsPostRESTCall("getControlFlowPreviousSteps", urlTemplate, requestBody, this.serverName, userId, currentStepGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public String setupProcessCall(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String callerGUID, String calledGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "setupProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "setupProcessCall");
        ProcessCallRequestBody requestBody = new ProcessCallRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/callers/{2}/called/{3}?assetManagerIsHome={4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupProcessCall", urlTemplate, requestBody, new Object[]{this.serverName, userId, callerGUID, calledGUID, infrastructureManagerIsHome});
        return results.getGUID();
    }

    public ProcessCallElement getProcessCall(String userId, String callerGUID, String calledGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCall";
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCall");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCall");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCall");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/callers/{2}/called/{3}/retrieve";
        ProcessCallElementResponse restResult = this.restClient.callProcessCallPostRESTCall("getProcessCall", urlTemplate, requestBody, this.serverName, userId, callerGUID, calledGUID);
        return restResult.getElement();
    }

    public void updateProcessCall(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String processCallGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "updateProcessCall");
        ProcessCallRequestBody requestBody = new ProcessCallRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/{2}/update";
        this.restClient.callVoidPostRESTCall("updateProcessCall", urlTemplate, requestBody, new Object[]{this.serverName, userId, processCallGUID});
    }

    public void clearProcessCall(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String processCallGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessCall";
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearProcessCall");
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", "clearProcessCall");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/{2}/remove";
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("clearProcessCall", urlTemplate, requestBody, new Object[]{this.serverName, userId, processCallGUID});
    }

    public List<ProcessCallElement> getProcessCalled(String userId, String callerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCalled";
        String callerGUIDParameterName = "callerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCalled");
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", "getProcessCalled");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/callers/{2}/called/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCalled", urlTemplate, requestBody, this.serverName, userId, callerGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ProcessCallElement> getProcessCallers(String userId, String calledGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getProcessCallers";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, "getProcessCallers");
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", "getProcessCallers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/process-calls/called/{2}/callers/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        ProcessCallElementsResponse restResult = this.restClient.callProcessCallsPostRESTCall("getProcessCallers", urlTemplate, requestBody, this.serverName, userId, calledGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public String setupLineageMapping(String userId, String sourceElementGUID, String destinationElementGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "setupLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "setupLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/sources/{2}/destinations/{3}";
        LineageMappingRequestBody requestBody = new LineageMappingRequestBody();
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("setupLineageMapping", urlTemplate, requestBody, new Object[]{this.serverName, userId, sourceElementGUID, destinationElementGUID});
        return restResult.getGUID();
    }

    public LineageMappingElement getLineageMapping(String userId, String sourceElementGUID, String destinationElementGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLineageMapping";
        String qualifiedNameParameterName = "qualifiedName";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLineageMapping");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "getLineageMapping");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "getLineageMapping");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNameParameterName("qualifiedName");
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/sources/{2}/destinations/{3}/retrieve";
        LineageMappingElementResponse restResult = this.restClient.callLineageMappingPostRESTCall("getLineageMapping", urlTemplate, requestBody, this.serverName, userId, sourceElementGUID, destinationElementGUID);
        return restResult.getElement();
    }

    public void updateLineageMapping(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String lineageMappingGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLineageMapping";
        String lineageMappingGUIDParameterName = "lineageMappingGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateLineageMapping");
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, "lineageMappingGUID", "updateLineageMapping");
        LineageMappingRequestBody requestBody = new LineageMappingRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/{2}/update";
        this.restClient.callVoidPostRESTCall("updateLineageMapping", urlTemplate, requestBody, new Object[]{this.serverName, userId, lineageMappingGUID});
    }

    public void clearLineageMapping(String userId, String lineageMappingGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLineageMapping";
        String lineageMappingGUIDParameterName = "lineageMapping";
        this.invalidParameterHandler.validateUserId(userId, "clearLineageMapping");
        this.invalidParameterHandler.validateGUID(lineageMappingGUID, "lineageMapping", "clearLineageMapping");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/{2}/remove";
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("clearLineageMapping", urlTemplate, requestBody, new Object[]{this.serverName, userId, lineageMappingGUID});
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String userId, String sourceElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDestinationLineageMappings";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDestinationLineageMappings");
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", "getDestinationLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/sources/{2}/destinations/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getDestinationLineageMappings", urlTemplate, requestBody, this.serverName, userId, sourceElementGUID, startFrom, pageSize);
        return results.getElementList();
    }

    public List<LineageMappingElement> getSourceLineageMappings(String userId, String destinationElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSourceLineageMappings";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSourceLineageMappings");
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", "getSourceLineageMappings");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/lineage-mappings/destinations/{2}/sources/retrieve?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        LineageMappingElementsResponse results = this.restClient.callLineageMappingsPostRESTCall("getSourceLineageMappings", urlTemplate, requestBody, this.serverName, userId, destinationElementGUID, startFrom, pageSize);
        return results.getElementList();
    }

    private List<ProcessElement> convertAssetElements(List<AssetElement> assetElements) {
        if (assetElements != null) {
            ArrayList<ProcessElement> hostElements = new ArrayList<ProcessElement>();
            for (AssetElement assetElement : assetElements) {
                hostElements.add(this.convertAssetElement(assetElement));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private ProcessElement convertAssetElement(AssetElement assetElement) {
        if (assetElement != null) {
            return new ProcessElement(assetElement);
        }
        return null;
    }
}

