/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ConnectionsManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ConnectionManagerClient
implements ConnectionsManagerInterface {
    private static final String connectionURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections";
    private static final String assetURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets";
    private String serverName;
    private String serverPlatformURLRoot;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private ITInfrastructureRESTClient restClient;

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ConnectionManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public String createConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "createConnection");
        String urlTemplate = this.serverPlatformURLRoot + connectionURLTemplatePrefix;
        ConnectionRequestBody requestBody = new ConnectionRequestBody(connectionProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createConnectionFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectionFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String elementGUIDParameterName = "connectionGUID";
        String propertiesParameterName = "connectionProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "updateConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionProperties", "updateConnection");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "updateConnection");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}?isMergeUpdate={3}";
        ConnectionRequestBody requestBody = new ConnectionRequestBody(connectionProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, isMergeUpdate});
    }

    public void setupConnectorType(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/connector-types/{3}";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID});
    }

    public void clearConnectorType(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/connector-types/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID});
    }

    public void setupEndpoint(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/endpoints/{3}";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, endpointGUID});
    }

    public void clearEndpoint(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/endpoints/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, endpointGUID});
    }

    public void setupEmbeddedConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/embedded-connections/{3}";
        EmbeddedConnectionRequestBody requestBody = new EmbeddedConnectionRequestBody();
        requestBody.setPosition(position);
        requestBody.setDisplayName(displayName);
        requestBody.setArguments(arguments);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID});
    }

    public void clearEmbeddedConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/embedded-connections/{3}/delete}";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID});
    }

    public void setupAssetConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/connections/{3}";
        AssetConnectionRequestBody requestBody = new AssetConnectionRequestBody();
        requestBody.setAssetSummary(assetSummary);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, connectionGUID});
    }

    public void clearAssetConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "embeddedConnectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/connections/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, connectionGUID});
    }

    public void removeConnection(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String elementGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID});
    }

    public List<ConnectionElement> findConnections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnection";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnection");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnection");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectionsResponse restResult = this.restClient.callMyConnectionsPostRESTCall("findConnection", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectionElement> getConnectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectionByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectionsResponse restResult = this.restClient.callMyConnectionsPostRESTCall("getConnectionByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ConnectionElement getConnectionByGUID(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connections/{2}";
        ConnectionResponse restResult = this.restClient.callMyConnectionGetRESTCall("getConnectionByGUID", urlTemplate, this.serverName, userId, connectionGUID);
        return restResult.getElement();
    }
}

