/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ITProfileManagementInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ITProfileElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ITProfileProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProfileIdentityProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.UserIdentityProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EffectiveDatesRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProfileIdentityRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ITProfileManagerClient
implements ITProfileManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private ITInfrastructureRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}";

    public ITProfileManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot);
    }

    public ITProfileManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ITProfileManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ITProfileManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ITProfileManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createITProfile(String userId, String externalSourceGUID, String externalSourceName, String itInfrastructureGUID, String itUserId, ITProfileProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createITProfile";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createITProfile");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createITProfile");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createITProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles";
        ITProfileRequestBody requestBody = new ITProfileRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setItInfrastructureGUID(itInfrastructureGUID);
        requestBody.setItUserId(itUserId);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createITProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateITProfile(String userId, String externalSourceGUID, String externalSourceName, String itProfileGUID, boolean isMergeUpdate, ITProfileProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateITProfile";
        String guidParameterName = "itProfileGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateITProfile");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "updateITProfile");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateITProfile");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateITProfile");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/{2}?isMergeUpdate={3}";
        ITProfileRequestBody requestBody = new ITProfileRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateITProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, itProfileGUID, isMergeUpdate});
    }

    public void deleteITProfile(String userId, String externalSourceGUID, String externalSourceName, String itProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteITProfile";
        String guidParameterName = "itProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteITProfile");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "deleteITProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteITProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, itProfileGUID});
    }

    public String addContactMethod(String userId, String externalSourceGUID, String externalSourceName, String itProfileGUID, ContactMethodProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addContactMethod";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "addContactMethod");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addContactMethod");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/{2}/contact-methods";
        ContactMethodRequestBody requestBody = new ContactMethodRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addContactMethod", urlTemplate, requestBody, new Object[]{this.serverName, userId, itProfileGUID});
        return restResult.getGUID();
    }

    public void deleteContactMethod(String userId, String externalSourceGUID, String externalSourceName, String contactMethodGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteContactMethod";
        String guidParameterName = "contactMethodGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteContactMethod");
        this.invalidParameterHandler.validateGUID(contactMethodGUID, "contactMethodGUID", "deleteContactMethod");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/contact-methods/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteContactMethod", urlTemplate, requestBody, new Object[]{this.serverName, userId, contactMethodGUID});
    }

    public void linkITInfrastructureToProfile(String userId, String externalSourceGUID, String externalSourceName, String itInfrastructureGUID, String itProfileGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkITInfrastructureToProfile";
        String itInfrastructureGUIDParameterName = "itInfrastructureGUID";
        String itProfileGUIDParameterName = "itProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkITInfrastructureToProfile");
        this.invalidParameterHandler.validateGUID(itInfrastructureGUID, "itInfrastructureGUID", "linkITInfrastructureToProfile");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "linkITInfrastructureToProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/profiles/{3}/link";
        EffectiveDatesRequestBody requestBody = new EffectiveDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("linkITInfrastructureToProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, itInfrastructureGUID, itProfileGUID});
    }

    public void updateITInfrastructureToProfile(String userId, String externalSourceGUID, String externalSourceName, String itInfrastructureGUID, String itProfileGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateITInfrastructureToProfile";
        String itInfrastructureGUIDParameterName = "itInfrastructureGUID";
        String itProfileGUIDParameterName = "itProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateITInfrastructureToProfile");
        this.invalidParameterHandler.validateGUID(itInfrastructureGUID, "itInfrastructureGUID", "updateITInfrastructureToProfile");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "updateITInfrastructureToProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/profiles/{3}/link/update";
        EffectiveDatesRequestBody requestBody = new EffectiveDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("updateITInfrastructureToProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, itInfrastructureGUID, itProfileGUID});
    }

    public void unlinkITInfrastructureFromProfile(String userId, String externalSourceGUID, String externalSourceName, String itInfrastructureGUID, String itProfileGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkITInfrastructureFromProfile";
        String itInfrastructureGUIDParameterName = "itInfrastructureGUID";
        String itProfileGUIDParameterName = "itProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkITInfrastructureFromProfile");
        this.invalidParameterHandler.validateGUID(itInfrastructureGUID, "itInfrastructureGUID", "unlinkITInfrastructureFromProfile");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "unlinkITInfrastructureFromProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/profiles/{3}/unlink";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("unlinkITInfrastructureFromProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, itInfrastructureGUID, itProfileGUID});
    }

    public ITProfileElement getITProfileByGUID(String userId, String itProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getITProfileByGUID";
        String guidParameterName = "itProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getITProfileByGUID");
        this.invalidParameterHandler.validateGUID(itProfileGUID, "itProfileGUID", "getITProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/{2}";
        ITProfileResponse restResult = this.restClient.callITProfileGetRESTCall("getITProfileByGUID", urlTemplate, this.serverName, userId, itProfileGUID);
        return restResult.getElement();
    }

    public ITProfileElement getITProfileByUserId(String userId, String itProfileUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getITProfileByGUID";
        String nameParameterName = "itProfileUserId";
        this.invalidParameterHandler.validateUserId(userId, "getITProfileByGUID");
        this.invalidParameterHandler.validateName(itProfileUserId, "itProfileUserId", "getITProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/user-ids/{2}";
        ITProfileResponse restResult = this.restClient.callITProfileGetRESTCall("getITProfileByGUID", urlTemplate, this.serverName, userId, itProfileUserId);
        return restResult.getElement();
    }

    public List<ITProfileElement> getITProfileByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getITProfileByName";
        String namePropertyName = "name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getITProfileByName");
        this.invalidParameterHandler.validateName(name, "name", "getITProfileByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        requestBody.setNameParameterName("name");
        ITProfileListResponse restResult = this.restClient.callITProfileListPostRESTCall("getITProfileByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<ITProfileElement> findITProfile(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findITProfile";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findITProfile");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findITProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/profiles/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ITProfileListResponse restResult = this.restClient.callITProfileListPostRESTCall("findITProfile", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createUserIdentity";
        String propertiesParameterName = "newIdentity";
        String qualifiedNameParameterName = "newIdentity.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createUserIdentity");
        this.invalidParameterHandler.validateObject((Object)newIdentity, "newIdentity", "createUserIdentity");
        this.invalidParameterHandler.validateName(newIdentity.getQualifiedName(), "newIdentity.qualifiedName", "createUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(newIdentity);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "updateUserIdentity");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateUserIdentity");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateUserIdentity");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}?isMergeUpdate={3}";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, isMergeUpdate});
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "deleteUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID});
    }

    public void addIdentityToProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addIdentityToProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "addIdentityToProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "addIdentityToProfile");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "addIdentityToProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}/profiles/{3}/link";
        ProfileIdentityRequestBody requestBody = new ProfileIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("addIdentityToProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, profileGUID});
    }

    public void updateProfileIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID, boolean isMergeUpdate, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateProfileIdentity";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateProfileIdentity");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "updateProfileIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "updateProfileIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}/profiles/{3}/link/update?isMergeUpdate={4}";
        ProfileIdentityRequestBody requestBody = new ProfileIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateProfileIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, profileGUID, isMergeUpdate});
    }

    public void removeIdentityFromProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeIdentityFromProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeIdentityFromProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "removeIdentityFromProfile");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "removeIdentityFromProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}/profiles/{3}/unlink";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("removeIdentityFromProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, profileGUID});
    }

    public List<UserIdentityElement> findUserIdentities(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findUserIdentities");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findUserIdentities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        UserIdentityListResponse restResult = this.restClient.callUserIdentityListPostRESTCall("findUserIdentities", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentitiesByName";
        String namePropertyName = "qualifiedName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentitiesByName");
        this.invalidParameterHandler.validateName(name, "name", "getUserIdentitiesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("qualifiedName");
        requestBody.setNameParameterName("name");
        UserIdentityListResponse restResult = this.restClient.callUserIdentityListPostRESTCall("getUserIdentitiesByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public UserIdentityElement getUserIdentityByGUID(String userId, String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentityByGUID");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "getUserIdentityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/{2}";
        UserIdentityResponse restResult = this.restClient.callUserIdentityGetRESTCall("getUserIdentityByGUID", urlTemplate, this.serverName, userId, userIdentityGUID);
        return restResult.getElement();
    }
}

