/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.EndpointManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class EndpointManagerClient
implements EndpointManagerInterface {
    private static final String endpointURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints";
    private String serverName;
    private String serverPlatformURLRoot;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private ITInfrastructureRESTClient restClient;

    public EndpointManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public EndpointManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot);
    }

    public EndpointManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public EndpointManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public EndpointManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public String createEndpoint(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String infrastructureGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "createEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "createEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + endpointURLTemplatePrefix;
        String urlTemplateWithGUID = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/for-infrastructure/{2}";
        EndpointRequestBody requestBody = new EndpointRequestBody(endpointProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = infrastructureGUID == null ? this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId}) : this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplateWithGUID, requestBody, new Object[]{this.serverName, userId, infrastructureGUID});
        return restResult.getGUID();
    }

    public String createEndpointFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String infrastructureGUID, String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        String networkAddressParameterName = "networkAddress";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createEndpointFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/network-address/{2}/from-template/{3}";
        String urlTemplateWithGUID = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/for-infrastructure/{2}/network-address/{3}/from-template/{3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = infrastructureGUID == null ? this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, networkAddress, templateGUID}) : this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplateWithGUID, requestBody, new Object[]{this.serverName, userId, infrastructureGUID, networkAddress, templateGUID});
        return restResult.getGUID();
    }

    public void updateEndpoint(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String elementGUIDParameterName = "endpointGUID";
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "updateEndpoint");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "updateEndpoint");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/{2}?isMergeUpdate={3}";
        EndpointRequestBody requestBody = new EndpointRequestBody(endpointProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, endpointGUID, isMergeUpdate});
    }

    public void removeEndpoint(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String elementGUIDParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, requestBody, new Object[]{this.serverName, userId, endpointGUID});
    }

    public List<EndpointElement> findEndpoints(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("findEndpoints", this.serverPlatformURLRoot + urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", this.serverPlatformURLRoot + urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsByNetworkAddress(String userId, String networkAddress, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameter = "networkAddress";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/by-network-address?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(networkAddress);
        requestBody.setNamePropertyName("networkAddress");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", this.serverPlatformURLRoot + urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<EndpointElement> getEndpointsForInfrastructure(String userId, String infrastructureGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsForInfrastructure";
        String guidParameterName = "infrastructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsForInfrastructure");
        this.invalidParameterHandler.validateGUID(infrastructureGUID, "infrastructureGUID", "getEndpointsForInfrastructure");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsForInfrastructure");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/for-infrastructure/{2}?startFrom={3}&pageSize={4}";
        EndpointsResponse restResult = this.restClient.callEndpointsGetRESTCall("getEndpointsForInfrastructure", urlTemplate, this.serverName, userId, infrastructureGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public EndpointElement getEndpointByGUID(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String guidParameterName = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/endpoints/{2}";
        EndpointResponse restResult = this.restClient.callEndpointGetRESTCall("getEndpointByGUID", urlTemplate, this.serverName, userId, endpointGUID);
        return restResult.getElement();
    }
}

