/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.DeploymentManagementInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ServerPurposeManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetRelationshipElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DeploymentElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementStatus;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.DeploymentProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetExtensionsRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetRelationshipListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EffectiveTimeMetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ElementStatusRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.RelatedAssetListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public abstract class AssetManagerClientBase
implements ServerPurposeManagerInterface,
DeploymentManagementInterface {
    static final String baseURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}";
    static final String referencableTypeName = "Referenceable";
    static final String assetTypeName = "Asset";
    static final String itAssetTypeName = "ITInfrastructure";
    static final String deployedOnRelationship = "DeployedOn";
    private static final String assetURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets";
    String serverName;
    String serverPlatformURLRoot;
    ITInfrastructureRESTClient restClient;
    private NullRequestBody nullRequestBody = new NullRequestBody();
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    AssetManagerClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    AssetManagerClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot);
    }

    AssetManagerClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    AssetManagerClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    AssetManagerClientBase(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, AssetProperties assetProperties, ElementStatus initialStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "qualifiedName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets?infrastructureManagerIsHome={2}";
        AssetRequestBody requestBody = new AssetRequestBody(assetProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setInitialStatus(initialStatus);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, infrastructureManagerIsHome});
        return restResult.getGUID();
    }

    String createAssetFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/from-template/{2}?infrastructureManagerIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, infrastructureManagerIsHome});
        return restResult.getGUID();
    }

    void updateAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, boolean isMergeUpdate, AssetProperties assetProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "assetGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "qualifiedName", methodName);
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}?isMergeUpdate={3}";
        AssetRequestBody requestBody = new AssetRequestBody(assetProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, isMergeUpdate});
    }

    void updateAssetStatus(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, ElementStatus newStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "assetGUID";
        String statusParameterName = "newStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)newStatus, "newStatus", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/status";
        ElementStatusRequestBody requestBody = new ElementStatusRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setElementStatus(newStatus);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    void setupRelatedAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, String relatedAssetGUID, Date effectiveFrom, Date effectiveTo, Map<String, Object> relationshipProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String relatedAssetGUIDParameterName = "relatedAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(relatedAssetGUID, "relatedAssetGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/" + relationshipTypeName + "/" + relatedAssetTypeName + "/{3}?infrastructureManagerIsHome={4}";
        AssetExtensionsRequestBody requestBody = new AssetExtensionsRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(relationshipProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, relatedAssetGUID, infrastructureManagerIsHome});
    }

    void updateAssetRelationship(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String relationshipGUID, String relationshipTypeName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, Map<String, Object> relationshipProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUIDParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/relationships/" + relationshipTypeName + "/{2}/update?isMergeUpdate={3}";
        AssetExtensionsRequestBody requestBody = new AssetExtensionsRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(relationshipProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID, isMergeUpdate});
    }

    void clearRelatedAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, String relatedAssetGUID, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String relatedAssetGUIDParameterName = "relatedAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(relatedAssetGUID, "relatedAssetGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/" + relationshipTypeName + "/" + relatedAssetTypeName + "/{3}/delete";
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, relatedAssetGUID});
    }

    void addClassification(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String assetTypeName, String assetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, Map<String, Object> classificationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/classify/" + classificationName + "?infrastructureManagerIsHome={3}";
        AssetExtensionsRequestBody requestBody = new AssetExtensionsRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(classificationProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, infrastructureManagerIsHome});
    }

    void updateClassification(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, Map<String, Object> classificationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/reclassify/" + classificationName + "?isMergeUpdate={3}";
        AssetExtensionsRequestBody requestBody = new AssetExtensionsRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(classificationProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, isMergeUpdate});
    }

    void clearClassification(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, String classificationName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/declassify/" + classificationName;
        EffectiveTimeMetadataSourceRequestBody requestBody = new EffectiveTimeMetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    void publishAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/publish";
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    void withdrawAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/withdraw";
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    void removeAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    List<AssetElement> findAssets(String userId, String searchString, String assetTypeName, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        AssetListResponse restResult = this.restClient.callAssetListPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    List<AssetElement> getAssetsByName(String userId, String name, String assetTypeName, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String urlTemplate = this.serverPlatformURLRoot + assetURLTemplatePrefix + assetTypeName + "/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        AssetListResponse restResult = this.restClient.callAssetListPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    List<AssetElement> getAssetsForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String infrastructureManagerGUIDParameterName = "infrastructureManagerGUID";
        String infrastructureManagerNameParameterName = "infrastructureManagerName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(infrastructureManagerGUID, "infrastructureManagerGUID", methodName);
        this.invalidParameterHandler.validateName(infrastructureManagerName, "infrastructureManagerName", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/infrastructure-managers/{2}/{3}/assets/" + assetTypeName + "?startFrom={4}&pageSize={5}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        AssetListResponse restResult = this.restClient.callAssetListPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, infrastructureManagerGUID, infrastructureManagerName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    AssetElement getAssetByGUID(String userId, String assetTypeName, String guid, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}";
        AssetResponse restResult = this.restClient.callAssetPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, guid);
        return restResult.getElement();
    }

    List<AssetRelationshipElement> getAssetRelationships(String userId, String assetTypeName, String assetGUID, int startingEnd, String relationshipTypeName, String relatedAssetTypeName, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/" + relationshipTypeName + "/" + relatedAssetTypeName + "/relationships?startingEnd={3}&startFrom={4}&pageSize={5}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        AssetRelationshipListResponse restResult = this.restClient.callAssetRelationshipListPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, assetGUID, startingEnd, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    List<RelatedAssetElement> getRelatedAssets(String userId, String assetTypeName, String assetGUID, int startingEnd, String relationshipTypeName, String relatedAssetTypeName, Date effectiveTime, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/assets/" + assetTypeName + "/{2}/" + relationshipTypeName + "/" + relatedAssetTypeName + "?startingEnd={3}&startFrom={4}&pageSize={5}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        RelatedAssetListResponse restResult = this.restClient.callRelatedAssetListPostRESTCall(methodName, urlTemplate, requestBody, this.serverName, userId, assetGUID, startingEnd, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public void addServerPurpose(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String itAssetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, Map<String, Object> classificationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addServerPurpose";
        this.addClassification(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, itAssetTypeName, itAssetGUID, classificationName, effectiveFrom, effectiveTo, classificationProperties, "addServerPurpose");
    }

    public void updateServerPurpose(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, Map<String, Object> classificationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateServerPurpose";
        this.updateClassification(userId, infrastructureManagerGUID, infrastructureManagerName, assetTypeName, assetGUID, classificationName, effectiveFrom, effectiveTo, isMergeUpdate, classificationProperties, "updateServerPurpose");
    }

    public void clearServerPurpose(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, String assetGUID, String classificationName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearServerPurpose";
        this.clearClassification(userId, infrastructureManagerGUID, infrastructureManagerName, assetTypeName, assetGUID, classificationName, effectiveTime, "clearServerPurpose");
    }

    public void deployITAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String itAssetGUID, String destinationGUID, DeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deployITAsset";
        Map propertyMap = null;
        Date effectiveFrom = null;
        Date effectiveTo = null;
        if (deploymentProperties != null) {
            propertyMap = deploymentProperties.cloneToMap();
            effectiveFrom = deploymentProperties.getEffectiveFrom();
            effectiveTo = deploymentProperties.getEffectiveTo();
        }
        this.setupRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, itAssetTypeName, itAssetGUID, deployedOnRelationship, assetTypeName, destinationGUID, effectiveFrom, effectiveTo, propertyMap, "deployITAsset");
    }

    public void updateITAssetDeployment(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String deploymentGUID, boolean isMergeUpdate, DeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateITAssetDeployment";
        Map propertyMap = null;
        Date effectiveFrom = null;
        Date effectiveTo = null;
        if (deploymentProperties != null) {
            propertyMap = deploymentProperties.cloneToMap();
            effectiveFrom = deploymentProperties.getEffectiveFrom();
            effectiveTo = deploymentProperties.getEffectiveTo();
        }
        this.updateAssetRelationship(userId, infrastructureManagerGUID, infrastructureManagerName, deploymentGUID, deployedOnRelationship, effectiveFrom, effectiveTo, isMergeUpdate, propertyMap, "updateITAssetDeployment");
    }

    public void clearDeployment(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itAssetGUID, String destinationGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDeployment";
        this.clearRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, itAssetTypeName, itAssetGUID, deployedOnRelationship, assetTypeName, destinationGUID, effectiveTime, "clearDeployment");
    }

    public List<DeploymentElement> getDeployedITAssets(String userId, String destinationGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDeployedITAssets";
        return this.convertRelatedAssetElements(this.getRelatedAssets(userId, assetTypeName, destinationGUID, 2, deployedOnRelationship, itAssetTypeName, effectiveTime, startFrom, pageSize, "getDeployedITAssets"));
    }

    public List<DeploymentElement> getDeploymentDestinations(String userId, String itAssetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDeploymentDestinations";
        return this.convertRelatedAssetElements(this.getRelatedAssets(userId, itAssetTypeName, itAssetGUID, 1, deployedOnRelationship, assetTypeName, effectiveTime, startFrom, pageSize, "getDeploymentDestinations"));
    }

    private List<DeploymentElement> convertRelatedAssetElements(List<RelatedAssetElement> relatedAssetElements) {
        if (relatedAssetElements != null) {
            ArrayList<DeploymentElement> deploymentElements = new ArrayList<DeploymentElement>();
            for (RelatedAssetElement relatedAssetElement : relatedAssetElements) {
                DeploymentElement element = new DeploymentElement();
                element.setElementHeader(relatedAssetElement.getElementHeader());
                element.setDeploymentProperties(new DeploymentProperties(relatedAssetElement.getProperties(), relatedAssetElement.getEffectiveFrom(), relatedAssetElement.getEffectiveTo()));
                element.setAssetElement(relatedAssetElement.getRelatedAsset());
                deploymentElements.add(element);
            }
            if (!deploymentElements.isEmpty()) {
                return deploymentElements;
            }
        }
        return null;
    }
}

