/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ConnectorTypeManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ConnectorTypeManagerClient
implements ConnectorTypeManagerInterface {
    private static final String connectorTypeURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types";
    private String serverName;
    private String serverPlatformURLRoot;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private ITInfrastructureRESTClient restClient;

    public ConnectorTypeManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectorTypeManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot);
    }

    public ConnectorTypeManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ConnectorTypeManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ITInfrastructureRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ConnectorTypeManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public String createConnectorType(String userId, String infrastructureManagerGUID, String infrastructureManagerName, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPrimitiveConnectorType";
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createPrimitiveConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "createPrimitiveConnectorType");
        this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "qualifiedName", "createPrimitiveConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + connectorTypeURLTemplatePrefix;
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody(connectorTypeProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPrimitiveConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createConnectorTypeFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectorTypeFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorTypeFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateConnectorType(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean isMergeUpdate, String connectorTypeGUID, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        String elementGUIDParameterName = "connectorTypeGUID";
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "updateConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "updateConnectorType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "qualifiedName", "updateConnectorType");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/{2}?isMergeUpdate={3}";
        ConnectorTypeRequestBody requestBody = new ConnectorTypeRequestBody(connectorTypeProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("updateConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectorTypeGUID, isMergeUpdate});
    }

    public void removeConnectorType(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        String elementGUIDParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("removeConnectorType", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectorTypeGUID});
    }

    public List<ConnectorTypeElement> findConnectorTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnectorType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("findConnectorType", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectorTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypeByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypeByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String guidParameterName = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/connector-types/{2}";
        ConnectorTypeResponse restResult = this.restClient.callConnectorTypeGetRESTCall("getConnectorTypeByGUID", urlTemplate, this.serverName, userId, connectorTypeGUID);
        return restResult.getElement();
    }
}

