/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.DataAssetManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataAssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class DataAssetManagerClient
extends ITInfrastructureClientBase
implements DataAssetManagerInterface {
    private static final String referenceDataClassification = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName;

    public DataAssetManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public DataAssetManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public DataAssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public DataAssetManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public DataAssetManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createDataAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, DataAssetProperties dataAssetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        AssetProperties assetProperties = dataAssetProperties.cloneToAsset();
        return super.createAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, assetProperties, null, "createDataAsset");
    }

    public String createDataAssetFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        return super.createAssetFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties, "createDataAssetFromTemplate");
    }

    public void updateDataAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, boolean isMergeUpdate, DataAssetProperties dataAssetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        AssetProperties assetProperties = dataAssetProperties.cloneToAsset();
        super.updateAsset(userId, infrastructureManagerGUID, infrastructureManagerName, assetGUID, isMergeUpdate, assetProperties, "updateDataAsset");
    }

    public void setDataAssetAsReferenceData(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        super.addClassification(userId, infrastructureManagerGUID, infrastructureManagerName, false, "Asset", assetGUID, referenceDataClassification, effectiveFrom, effectiveTo, null, "setDataAssetAsReferenceData");
    }

    public void clearDataAssetAsReferenceData(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        super.clearClassification(userId, infrastructureManagerGUID, infrastructureManagerName, "Asset", assetGUID, referenceDataClassification, effectiveTime, "clearDataAssetAsReferenceData");
    }

    public void publishDataAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        super.publishAsset(userId, assetGUID, "publishDataAsset");
    }

    public void withdrawDataAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        super.withdrawAsset(userId, assetGUID, "withdrawDataAsset");
    }

    public void removeDataAsset(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        super.removeAsset(userId, infrastructureManagerGUID, infrastructureManagerName, assetGUID, "removeDataAsset");
    }

    public List<DataAssetElement> findDataAssets(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataAssets";
        return this.convertAssetElements(super.findAssets(userId, searchString, "Asset", effectiveTime, startFrom, pageSize, "findDataAssets"));
    }

    public List<DataAssetElement> getDataAssetsByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsByName";
        return this.convertAssetElements(super.getAssetsByName(userId, name, "Asset", effectiveTime, startFrom, pageSize, "getDataAssetsByName"));
    }

    public List<DataAssetElement> getDataAssetsForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetsForInfrastructureManager";
        return this.convertAssetElements(super.getAssetsForInfrastructureManager(userId, infrastructureManagerGUID, infrastructureManagerName, "Asset", effectiveTime, startFrom, pageSize, "getDataAssetsForInfrastructureManager"));
    }

    public DataAssetElement getDataAssetByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataAssetByGUID";
        return this.convertAssetElement(super.getAssetByGUID(userId, "Asset", guid, null, "getDataAssetByGUID"));
    }

    private List<DataAssetElement> convertAssetElements(List<AssetElement> assetElements) {
        if (assetElements != null) {
            ArrayList<DataAssetElement> hostElements = new ArrayList<DataAssetElement>();
            for (AssetElement assetElement : assetElements) {
                hostElements.add(this.convertAssetElement(assetElement));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private DataAssetElement convertAssetElement(AssetElement assetElement) {
        if (assetElement != null) {
            return new DataAssetElement(assetElement);
        }
        return null;
    }
}

