/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.SoftwareServerPlatformManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerPlatformElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.SoftwareServerPlatformProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class PlatformManagerClient
extends ITInfrastructureClientBase
implements SoftwareServerPlatformManagerInterface {
    private static final String platformEntityType = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName;

    public PlatformManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public PlatformManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public PlatformManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public PlatformManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public PlatformManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createSoftwareServerPlatform(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, SoftwareServerPlatformProperties platformProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServerPlatform";
        AssetProperties assetProperties = platformProperties.cloneToAsset();
        return super.createAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, assetProperties, null, "createSoftwareServerPlatform");
    }

    public String createSoftwareServerPlatformFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServerPlatformFromTemplate";
        return super.createAssetFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties, "createSoftwareServerPlatformFromTemplate");
    }

    public void updateSoftwareServerPlatform(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String platformGUID, boolean isMergeUpdate, SoftwareServerPlatformProperties platformProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSoftwareServerPlatform";
        AssetProperties assetProperties = platformProperties.cloneToAsset();
        super.updateAsset(userId, infrastructureManagerGUID, infrastructureManagerName, platformGUID, isMergeUpdate, assetProperties, "updateSoftwareServerPlatform");
    }

    public void publishSoftwareServerPlatform(String userId, String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishSoftwareServerPlatform";
        super.publishAsset(userId, platformGUID, "publishSoftwareServerPlatform");
    }

    public void withdrawSoftwareServerPlatform(String userId, String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawSoftwareServerPlatform";
        super.withdrawAsset(userId, platformGUID, "withdrawSoftwareServerPlatform");
    }

    public void removeSoftwareServerPlatform(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSoftwareServerPlatform";
        super.removeAsset(userId, infrastructureManagerGUID, infrastructureManagerName, platformGUID, "removeSoftwareServerPlatform");
    }

    public List<SoftwareServerPlatformElement> findSoftwareServerPlatforms(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSoftwareServerPlatforms";
        return this.convertAssetElements(super.findAssets(userId, searchString, platformEntityType, effectiveTime, startFrom, pageSize, "findSoftwareServerPlatforms"));
    }

    public List<SoftwareServerPlatformElement> getSoftwareServerPlatformsByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServerPlatformsByName";
        return this.convertAssetElements(super.getAssetsByName(userId, name, platformEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServerPlatformsByName"));
    }

    public List<SoftwareServerPlatformElement> getSoftwareServerPlatformsByDeployedImplType(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServerPlatformsByDeployedImplType";
        return this.convertAssetElements(super.getAssetsByDeployedImplementationType(userId, name, platformEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServerPlatformsByDeployedImplType"));
    }

    public List<SoftwareServerPlatformElement> getSoftwareServerPlatformsForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServerPlatformsForInfrastructureManager";
        return this.convertAssetElements(super.getAssetsForInfrastructureManager(userId, infrastructureManagerGUID, infrastructureManagerName, platformEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServerPlatformsForInfrastructureManager"));
    }

    public SoftwareServerPlatformElement getSoftwareServerPlatformByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServerPlatformByGUID";
        return this.convertAssetElement(super.getAssetByGUID(userId, platformEntityType, guid, null, "getSoftwareServerPlatformByGUID"));
    }

    private List<SoftwareServerPlatformElement> convertAssetElements(List<AssetElement> assetElements) {
        if (assetElements != null) {
            ArrayList<SoftwareServerPlatformElement> hostElements = new ArrayList<SoftwareServerPlatformElement>();
            for (AssetElement assetElement : assetElements) {
                hostElements.add(this.convertAssetElement(assetElement));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private SoftwareServerPlatformElement convertAssetElement(AssetElement assetElement) {
        if (assetElement != null) {
            return new SoftwareServerPlatformElement(assetElement);
        }
        return null;
    }
}

