/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.SoftwareCapabilityManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.SoftwareServerCapabilityManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUseRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUseResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUsesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UseTypeRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ServerAssetUseElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.ServerAssetUseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.CapabilityDeploymentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.SoftwareCapabilityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.SoftwareServerCapabilityProperties;

public class CapabilityManagerClient
extends ITInfrastructureClientBase
implements SoftwareCapabilityManagerInterface,
SoftwareServerCapabilityManagerInterface {
    private static final String capabilityURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities";
    private static final String assetUsesURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses";
    private static final String softwareCapabilityTypeName = "SoftwareCapability";
    private static final String deploymentRelationshipTypeName = "SupportedSoftwareCapability";

    public CapabilityManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public CapabilityManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public CapabilityManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public CapabilityManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public CapabilityManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    @Deprecated
    public String createSoftwareServerCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String classificationName, SoftwareServerCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (capabilityProperties != null && capabilityProperties.getTypeName() == null) {
            capabilityProperties.setTypeName(softwareCapabilityTypeName);
        }
        return this.createSoftwareCapability(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, classificationName, (SoftwareCapabilityProperties)capabilityProperties);
    }

    @Deprecated
    public String createSoftwareServerCapabilityFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createSoftwareCapabilityFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    @Deprecated
    public void updateSoftwareServerCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String capabilityGUID, boolean isMergeUpdate, SoftwareServerCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateSoftwareCapability(userId, infrastructureManagerGUID, infrastructureManagerName, capabilityGUID, isMergeUpdate, (SoftwareCapabilityProperties)capabilityProperties);
    }

    @Deprecated
    public void removeSoftwareServerCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String capabilityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeSoftwareCapability(userId, infrastructureManagerGUID, infrastructureManagerName, capabilityGUID);
    }

    @Deprecated
    public List<SoftwareServerCapabilityElement> findSoftwareServerCapabilities(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getSoftwareServerCapabilityElements(this.findSoftwareCapabilities(userId, searchString, effectiveTime, startFrom, pageSize));
    }

    @Deprecated
    public List<SoftwareServerCapabilityElement> getSoftwareServerCapabilitiesByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getSoftwareServerCapabilityElements(this.getSoftwareCapabilitiesByName(userId, name, effectiveTime, startFrom, pageSize));
    }

    @Deprecated
    public SoftwareServerCapabilityElement getSoftwareServerCapabilityByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getSoftwareServerCapabilityElement(this.getSoftwareCapabilityByGUID(userId, guid));
    }

    @Deprecated
    private List<SoftwareServerCapabilityElement> getSoftwareServerCapabilityElements(List<SoftwareCapabilityElement> softwareCapabilityElements) {
        if (softwareCapabilityElements != null) {
            ArrayList<SoftwareServerCapabilityElement> softwareServerCapabilityElements = new ArrayList<SoftwareServerCapabilityElement>();
            for (SoftwareCapabilityElement softwareCapabilityElement : softwareCapabilityElements) {
                if (softwareCapabilityElement == null) continue;
                softwareCapabilityElements.add((SoftwareCapabilityElement)this.getSoftwareServerCapabilityElement(softwareCapabilityElement));
            }
            return softwareServerCapabilityElements;
        }
        return null;
    }

    @Deprecated
    private SoftwareServerCapabilityElement getSoftwareServerCapabilityElement(SoftwareCapabilityElement softwareCapabilityElement) {
        if (softwareCapabilityElement != null) {
            SoftwareServerCapabilityElement softwareServerCapabilityElement = new SoftwareServerCapabilityElement();
            softwareServerCapabilityElement.setElementHeader(softwareCapabilityElement.getElementHeader());
            softwareServerCapabilityElement.setProperties(softwareCapabilityElement.getProperties());
            return softwareServerCapabilityElement;
        }
        return null;
    }

    public String createSoftwareCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String classificationName, SoftwareCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServerCapability";
        String propertiesParameterName = "capabilityProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSoftwareServerCapability");
        this.invalidParameterHandler.validateObject((Object)capabilityProperties, "capabilityProperties", "createSoftwareServerCapability");
        this.invalidParameterHandler.validateName(capabilityProperties.getQualifiedName(), "qualifiedName", "createSoftwareServerCapability");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities?infrastructureManagerIsHome={2}";
        SoftwareCapabilityRequestBody requestBody = new SoftwareCapabilityRequestBody(capabilityProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setClassificationName(classificationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSoftwareServerCapability", urlTemplate, requestBody, new Object[]{this.serverName, userId, infrastructureManagerIsHome});
        return restResult.getGUID();
    }

    public String createSoftwareCapabilityFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServerCapabilityFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSoftwareServerCapabilityFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSoftwareServerCapabilityFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createSoftwareServerCapabilityFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createSoftwareServerCapabilityFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/from-template/{2}?infrastructureManagerIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSoftwareServerCapabilityFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, infrastructureManagerIsHome});
        return restResult.getGUID();
    }

    public void updateSoftwareCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String capabilityGUID, boolean isMergeUpdate, SoftwareCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSoftwareCapability";
        String elementGUIDParameterName = "capabilityGUID";
        String propertiesParameterName = "capabilityProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSoftwareCapability");
        this.invalidParameterHandler.validateGUID(capabilityGUID, "capabilityGUID", "updateSoftwareCapability");
        this.invalidParameterHandler.validateObject((Object)capabilityProperties, "capabilityProperties", "updateSoftwareCapability");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(capabilityProperties.getQualifiedName(), "qualifiedName", "updateSoftwareCapability");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/{2}?isMergeUpdate={3}";
        SoftwareCapabilityRequestBody requestBody = new SoftwareCapabilityRequestBody(capabilityProperties);
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("updateSoftwareCapability", urlTemplate, requestBody, new Object[]{this.serverName, userId, capabilityGUID, isMergeUpdate});
    }

    public void deployCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String capabilityGUID, String infrastructureAssetGUID, CapabilityDeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deployCapability";
        Map propertyMap = null;
        Date effectiveFrom = null;
        Date effectiveTo = null;
        if (deploymentProperties != null) {
            propertyMap = deploymentProperties.cloneToMap();
            effectiveFrom = deploymentProperties.getEffectiveFrom();
            effectiveTo = deploymentProperties.getEffectiveTo();
        }
        super.setupRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, "ITInfrastructure", infrastructureAssetGUID, deploymentRelationshipTypeName, softwareCapabilityTypeName, capabilityGUID, effectiveFrom, effectiveTo, propertyMap, "deployCapability");
    }

    public void updateCapabilityDeployment(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String deploymentGUID, boolean isMergeUpdate, CapabilityDeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCapabilityDeployment";
        Map propertyMap = null;
        Date effectiveFrom = null;
        Date effectiveTo = null;
        if (deploymentProperties != null) {
            propertyMap = deploymentProperties.cloneToMap();
            effectiveFrom = deploymentProperties.getEffectiveFrom();
            effectiveTo = deploymentProperties.getEffectiveTo();
        }
        super.updateAssetRelationship(userId, infrastructureManagerGUID, infrastructureManagerName, deploymentGUID, deploymentRelationshipTypeName, effectiveFrom, effectiveTo, isMergeUpdate, propertyMap, "updateCapabilityDeployment");
    }

    public void removeCapabilityDeployment(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itAssetGUID, String capabilityGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCapabilityDeployment";
        super.clearRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, "ITInfrastructure", itAssetGUID, deploymentRelationshipTypeName, softwareCapabilityTypeName, capabilityGUID, effectiveTime, "removeCapabilityDeployment");
    }

    public void removeSoftwareCapability(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String capabilityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSoftwareCapability";
        String elementGUIDParameterName = "capabilityGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSoftwareCapability");
        this.invalidParameterHandler.validateGUID(capabilityGUID, "capabilityGUID", "removeSoftwareCapability");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/{2}/delete";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("removeSoftwareCapability", urlTemplate, requestBody, new Object[]{this.serverName, userId, capabilityGUID});
    }

    public List<SoftwareCapabilityElement> findSoftwareCapabilities(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSoftwareCapabilities";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSoftwareCapabilities");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSoftwareCapabilities");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSoftwareCapabilities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        SoftwareCapabilitiesResponse restResult = this.restClient.callSoftwareServerCapabilitiesPostRESTCall("findSoftwareCapabilities", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<SoftwareCapabilityElement> getSoftwareCapabilitiesByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareCapabilitiesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSoftwareCapabilitiesByName");
        this.invalidParameterHandler.validateName(name, "name", "getSoftwareCapabilitiesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSoftwareCapabilitiesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        SoftwareCapabilitiesResponse restResult = this.restClient.callSoftwareServerCapabilitiesPostRESTCall("getSoftwareCapabilitiesByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<RelatedAssetElement> getSoftwareCapabilityDeployments(String userId, String guid, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareCapabilityDeployments";
        return super.getRelatedAssets(userId, softwareCapabilityTypeName, guid, 2, null, "ITInfrastructure", effectiveTime, startFrom, pageSize, "getSoftwareCapabilityDeployments");
    }

    public List<SoftwareCapabilityElement> getDeployedSoftwareCapabilities(String userId, String itAssetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDeployedSoftwareCapabilities";
        String guidParameterName = "itAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDeployedSoftwareCapabilities");
        this.invalidParameterHandler.validateGUID(itAssetGUID, "itAssetGUID", "getDeployedSoftwareCapabilities");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDeployedSoftwareCapabilities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/deployed-on-it-assets/{2}?startFrom={3}&pageSize={4}";
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        SoftwareCapabilitiesResponse restResult = this.restClient.callSoftwareServerCapabilitiesPostRESTCall("getDeployedSoftwareCapabilities", urlTemplate, requestBody, new Object[]{this.serverName, userId, itAssetGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<SoftwareCapabilityElement> getSoftwareCapabilitiesForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareCapabilitiesForInfrastructureManager";
        String infrastructureManagerGUIDParameterName = "infrastructureManagerGUID";
        String infrastructureManagerNameParameterName = "infrastructureManagerName";
        this.invalidParameterHandler.validateUserId(userId, "getSoftwareCapabilitiesForInfrastructureManager");
        this.invalidParameterHandler.validateGUID(infrastructureManagerGUID, "infrastructureManagerGUID", "getSoftwareCapabilitiesForInfrastructureManager");
        this.invalidParameterHandler.validateName(infrastructureManagerName, "infrastructureManagerName", "getSoftwareCapabilitiesForInfrastructureManager");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSoftwareCapabilitiesForInfrastructureManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/infrastructure-managers/{2}/{3}/software-capabilities?startFrom={4}&pageSize={5}";
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        SoftwareCapabilitiesResponse restResult = this.restClient.callSoftwareServerCapabilitiesPostRESTCall("getSoftwareCapabilitiesForInfrastructureManager", urlTemplate, requestBody, new Object[]{this.serverName, userId, infrastructureManagerGUID, infrastructureManagerName, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public SoftwareCapabilityElement getSoftwareCapabilityByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareCapabilityByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getSoftwareCapabilityByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getSoftwareCapabilityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/software-capabilities/{2}";
        SoftwareCapabilityResponse restResult = this.restClient.callSoftwareServerCapabilityGetRESTCall("getSoftwareCapabilityByGUID", urlTemplate, new Object[]{this.serverName, userId, guid});
        return restResult.getElement();
    }

    public String createServerAssetUse(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String capabilityGUID, String assetGUID, ServerAssetUseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createServerAssetUse";
        String capabilityGUIDParameterName = "capabilityGUID";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "createServerAssetUse");
        this.invalidParameterHandler.validateGUID(capabilityGUID, "capabilityGUID", "createServerAssetUse");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "createServerAssetUse");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/software-capabilities/{2}/assets/{3}?infrastructureManagerIsHome={4}";
        ServerAssetUseRequestBody requestBody = new ServerAssetUseRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createServerAssetUse", urlTemplate, requestBody, new Object[]{this.serverName, userId, capabilityGUID, assetGUID, infrastructureManagerIsHome});
        return restResult.getGUID();
    }

    public void updateServerAssetUse(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String serverAssetUseGUID, boolean isMergeUpdate, ServerAssetUseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateServerAssetUse";
        String elementGUIDParameterName = "serverAssetUseGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateServerAssetUse");
        this.invalidParameterHandler.validateGUID(serverAssetUseGUID, "serverAssetUseGUID", "updateServerAssetUse");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/{2}?isMergeUpdate={3}";
        ServerAssetUseRequestBody requestBody = new ServerAssetUseRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateServerAssetUse", urlTemplate, requestBody, new Object[]{this.serverName, userId, serverAssetUseGUID, isMergeUpdate});
    }

    public void removeServerAssetUse(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String serverAssetUseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeServerAssetUse";
        String elementGUIDParameterName = "serverAssetUseGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeServerAssetUse");
        this.invalidParameterHandler.validateGUID(serverAssetUseGUID, "serverAssetUseGUID", "removeServerAssetUse");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/{2}/delete";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(infrastructureManagerGUID);
        requestBody.setExternalSourceName(infrastructureManagerName);
        this.restClient.callVoidPostRESTCall("removeServerAssetUse", urlTemplate, requestBody, new Object[]{this.serverName, userId, serverAssetUseGUID});
    }

    public List<ServerAssetUseElement> getServerAssetUsesForCapability(String userId, String capabilityGUID, ServerAssetUseType useType, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerAssetUsesForCapability";
        String elementGUIDParameterName = "capabilityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getServerAssetUsesForCapability");
        this.invalidParameterHandler.validateGUID(capabilityGUID, "capabilityGUID", "getServerAssetUsesForCapability");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getServerAssetUsesForCapability");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/software-capabilities/{2}?startFrom={3}&pageSize={4}";
        UseTypeRequestBody requestBody = new UseTypeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setUseType(useType);
        ServerAssetUsesResponse restResult = this.restClient.callServerAssetUseListPostRESTCall("getServerAssetUsesForCapability", urlTemplate, requestBody, new Object[]{this.serverName, userId, capabilityGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ServerAssetUseElement> getCapabilityUsesForAsset(String userId, String assetGUID, ServerAssetUseType useType, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCapabilityUsesForAsset";
        String elementGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCapabilityUsesForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getCapabilityUsesForAsset");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCapabilityUsesForAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/assets/{2}?startFrom={3}&pageSize={4}";
        UseTypeRequestBody requestBody = new UseTypeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setUseType(useType);
        ServerAssetUsesResponse restResult = this.restClient.callServerAssetUseListPostRESTCall("getCapabilityUsesForAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ServerAssetUseElement> getServerAssetUsesForElements(String userId, String capabilityGUID, String assetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerAssetUsesForElements";
        String capabilityGUIDParameterName = "capabilityGUID";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getServerAssetUsesForElements");
        this.invalidParameterHandler.validateGUID(capabilityGUID, "capabilityGUID", "getServerAssetUsesForElements");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getServerAssetUsesForElements");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getServerAssetUsesForElements");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/software-capabilities/{2}/assets/{3}/by-elements?startFrom={4}&pageSize={5}";
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        ServerAssetUsesResponse restResult = this.restClient.callServerAssetUseListPostRESTCall("getServerAssetUsesForElements", urlTemplate, requestBody, new Object[]{this.serverName, userId, capabilityGUID, assetGUID, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public ServerAssetUseElement getServerAssetUseByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerAssetUseByGUID";
        String elementGUIDParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getServerAssetUseByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getServerAssetUseByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/it-infrastructure/users/{1}/server-asset-uses/{2}";
        ServerAssetUseResponse restResult = this.restClient.callServerAssetUseGetRESTCall("getServerAssetUseByGUID", urlTemplate, new Object[]{this.serverName, userId, guid});
        return restResult.getElement();
    }
}

