/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.HostManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.HostElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.HostProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class HostManagerClient
extends ITInfrastructureClientBase
implements HostManagerInterface {
    private static final String hostEntityType = OpenMetadataType.HOST.typeName;
    private static final String hostClusterEntityType = OpenMetadataType.HOST_CLUSTER.typeName;
    private static final String hostClusterMemberRelationship = OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeName;

    public HostManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public HostManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public HostManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public HostManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public HostManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createHost(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, HostProperties hostProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createHost";
        AssetProperties assetProperties = hostProperties.cloneToAsset();
        return super.createAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, assetProperties, null, "createHost");
    }

    public String createHostFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createHost";
        return super.createAssetFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties, "createHost");
    }

    public void updateHost(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String hostGUID, boolean isMergeUpdate, HostProperties hostProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateHost";
        AssetProperties assetProperties = hostProperties.cloneToAsset();
        super.updateAsset(userId, infrastructureManagerGUID, infrastructureManagerName, hostGUID, isMergeUpdate, assetProperties, "updateHost");
    }

    public void setupClusterMember(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String hostGUID, String clusterMemberGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupClusterMember";
        super.setupRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, hostClusterEntityType, hostGUID, hostClusterMemberRelationship, hostEntityType, clusterMemberGUID, effectiveFrom, effectiveTo, null, "setupClusterMember");
    }

    public void clearClusterMember(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String hostGUID, String clusterMemberGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearClusterMember";
        super.clearRelatedAsset(userId, infrastructureManagerGUID, infrastructureManagerName, hostClusterEntityType, hostGUID, hostClusterMemberRelationship, hostEntityType, clusterMemberGUID, effectiveTime, "clearClusterMember");
    }

    public void publishHost(String userId, String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishHost";
        super.publishAsset(userId, hostGUID, "publishHost");
    }

    public void withdrawHost(String userId, String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawHost";
        super.withdrawAsset(userId, hostGUID, "withdrawHost");
    }

    public void removeHost(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeHost";
        super.removeAsset(userId, infrastructureManagerGUID, infrastructureManagerName, hostGUID, "removeHost");
    }

    public List<HostElement> findHosts(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findHosts";
        return this.convertAssetElements(super.findAssets(userId, searchString, hostEntityType, effectiveTime, startFrom, pageSize, "findHosts"));
    }

    public List<HostElement> getHostsByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getHostsByName";
        return this.convertAssetElements(super.getAssetsByName(userId, name, hostEntityType, effectiveTime, startFrom, pageSize, "getHostsByName"));
    }

    public List<HostElement> getHostsForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getHostsForInfrastructureManager";
        return this.convertAssetElements(super.getAssetsForInfrastructureManager(userId, infrastructureManagerGUID, infrastructureManagerName, hostEntityType, effectiveTime, startFrom, pageSize, "getHostsForInfrastructureManager"));
    }

    public List<HostElement> getClusterMembersForHost(String userId, String hostGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getClusterMembersForHost";
        return this.convertRelatedAssetElements(super.getRelatedAssets(userId, hostClusterEntityType, hostGUID, 1, hostClusterMemberRelationship, hostEntityType, effectiveTime, startFrom, pageSize, "getClusterMembersForHost"));
    }

    public HostElement getHostByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getHostByGUID";
        return this.convertAssetElement(super.getAssetByGUID(userId, hostEntityType, guid, null, "getHostByGUID"));
    }

    private List<HostElement> convertRelatedAssetElements(List<RelatedAssetElement> relatedAssetElements) {
        if (relatedAssetElements != null) {
            ArrayList<HostElement> hostElements = new ArrayList<HostElement>();
            for (RelatedAssetElement relatedAssetElement : relatedAssetElements) {
                hostElements.add(this.convertAssetElement(relatedAssetElement.getRelatedAsset()));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private List<HostElement> convertAssetElements(List<AssetElement> assetElements) {
        if (assetElements != null) {
            ArrayList<HostElement> hostElements = new ArrayList<HostElement>();
            for (AssetElement assetElement : assetElements) {
                hostElements.add(this.convertAssetElement(assetElement));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private HostElement convertAssetElement(AssetElement assetElement) {
        if (assetElement != null) {
            return new HostElement(assetElement);
        }
        return null;
    }
}

