/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.SoftwareServerManagerInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureClientBase;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.SoftwareServerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ServerManagerClient
extends ITInfrastructureClientBase
implements SoftwareServerManagerInterface {
    private static final String serverEntityType = OpenMetadataType.SOFTWARE_SERVER.typeName;

    public ServerManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public ServerManagerClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public ServerManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public ServerManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public ServerManagerClient(String serverName, String serverPlatformURLRoot, ITInfrastructureRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createSoftwareServer(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, SoftwareServerProperties softwareServerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServer";
        AssetProperties assetProperties = softwareServerProperties.cloneToAsset();
        return super.createAsset(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, assetProperties, null, "createSoftwareServer");
    }

    public String createSoftwareServerFromTemplate(String userId, String infrastructureManagerGUID, String infrastructureManagerName, boolean infrastructureManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSoftwareServerFromTemplate";
        return super.createAssetFromTemplate(userId, infrastructureManagerGUID, infrastructureManagerName, infrastructureManagerIsHome, templateGUID, templateProperties, "createSoftwareServerFromTemplate");
    }

    public void updateSoftwareServer(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String softwareServerGUID, boolean isMergeUpdate, SoftwareServerProperties softwareServerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSoftwareServer";
        AssetProperties assetProperties = softwareServerProperties.cloneToAsset();
        super.updateAsset(userId, infrastructureManagerGUID, infrastructureManagerName, softwareServerGUID, isMergeUpdate, assetProperties, "updateSoftwareServer");
    }

    public void publishSoftwareServer(String userId, String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishSoftwareServer";
        super.publishAsset(userId, softwareServerGUID, "publishSoftwareServer");
    }

    public void withdrawSoftwareServer(String userId, String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawSoftwareServer";
        super.withdrawAsset(userId, softwareServerGUID, "withdrawSoftwareServer");
    }

    public void removeSoftwareServer(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSoftwareServer";
        super.removeAsset(userId, infrastructureManagerGUID, infrastructureManagerName, softwareServerGUID, "removeSoftwareServer");
    }

    public List<SoftwareServerElement> findSoftwareServers(String userId, String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSoftwareServers";
        return this.convertAssetElements(super.findAssets(userId, searchString, serverEntityType, effectiveTime, startFrom, pageSize, "findSoftwareServers"));
    }

    public List<SoftwareServerElement> getSoftwareServersByName(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServersByName";
        return this.convertAssetElements(super.getAssetsByName(userId, name, serverEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServersByName"));
    }

    public List<SoftwareServerElement> getSoftwareServersByDeployedImplType(String userId, String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServersByDeployedImplType";
        return this.convertAssetElements(super.getAssetsByDeployedImplementationType(userId, name, serverEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServersByDeployedImplType"));
    }

    public List<SoftwareServerElement> getSoftwareServersForInfrastructureManager(String userId, String infrastructureManagerGUID, String infrastructureManagerName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServersForInfrastructureManager";
        return this.convertAssetElements(super.getAssetsForInfrastructureManager(userId, infrastructureManagerGUID, infrastructureManagerName, serverEntityType, effectiveTime, startFrom, pageSize, "getSoftwareServersForInfrastructureManager"));
    }

    public SoftwareServerElement getSoftwareServerByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSoftwareServerByGUID";
        return this.convertAssetElement(super.getAssetByGUID(userId, serverEntityType, guid, null, "getSoftwareServerByGUID"));
    }

    private List<SoftwareServerElement> convertAssetElements(List<AssetElement> assetElements) {
        if (assetElements != null) {
            ArrayList<SoftwareServerElement> hostElements = new ArrayList<SoftwareServerElement>();
            for (AssetElement assetElement : assetElements) {
                hostElements.add(this.convertAssetElement(assetElement));
            }
            if (!hostElements.isEmpty()) {
                return hostElements;
            }
        }
        return null;
    }

    private SoftwareServerElement convertAssetElement(AssetElement assetElement) {
        if (assetElement != null) {
            return new SoftwareServerElement(assetElement);
        }
        return null;
    }
}

