/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.auditlog.ITInfrastructureAuditCode;
import org.odpi.openmetadata.accessservices.itinfrastructure.listener.ITInfrastructureOMRSTopicListener;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ITInfrastructureAdmin
extends AccessServiceAdmin {
    private OMRSAuditLog auditLog = null;
    private ITInfrastructureServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        ITInfrastructureAuditCode auditCode = ITInfrastructureAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new ITInfrastructureServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                ITInfrastructureOMRSTopicListener omrsTopicListener = new ITInfrastructureOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), supportedZones, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditCode = ITInfrastructureAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditCode = ITInfrastructureAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        ITInfrastructureAuditCode auditCode = ITInfrastructureAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

