/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.ffdc.ITInfrastructureAuditCode;
import org.odpi.openmetadata.accessservices.itinfrastructure.listener.ITInfrastructureOMRSTopicListener;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ITInfrastructureAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private ITInfrastructureServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", ITInfrastructureAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new ITInfrastructureServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                ITInfrastructureOMRSTopicListener omrsTopicListener = new ITInfrastructureOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), supportedZones, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditLog.logMessage("initialize", ITInfrastructureAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", ITInfrastructureAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.IT_INFRASTRUCTURE_OMAS.getAccessServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", ITInfrastructureAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

