/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class ITInfrastructureRESTServices {
    private static ITInfrastructureInstanceHandler instanceHandler = new ITInfrastructureInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ITInfrastructureRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createEndpoint(String serverName, String userId, String infrastructureGUID, EndpointRequestBody requestBody) {
        String methodName = "createEndpoint";
        String infrastructureGUIDParameterName = "infrastructureGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpoint");
            if (requestBody != null) {
                String endpointGUID = handler.createEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), "createEndpoint");
                if (endpointGUID != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), "createEndpoint");
                }
                if (infrastructureGUID != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, "infrastructureGUID", "ITInfrastructure", endpointGUID, "endpointGUID", "Endpoint", "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", null, "createEndpoint");
                }
                response.setGUID(endpointGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String infrastructureGUID, String networkAddress, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createEndpointFromTemplate";
        String infrastructureGUIDParameterName = "infrastructureGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpointFromTemplate");
            if (requestBody != null) {
                String endpointGUID = handler.createEndpointFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), networkAddress, "createEndpointFromTemplate");
                if (infrastructureGUID != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, "infrastructureGUID", "ITInfrastructure", endpointGUID, "endpointGUID", "Endpoint", "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", null, "createEndpointFromTemplate");
                }
                response.setGUID(endpointGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, EndpointRequestBody requestBody) {
        String methodName = "updateEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "updateEndpoint");
            if (requestBody != null) {
                handler.updateEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, "updateEndpoint");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), "updateEndpoint");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "removeEndpoint");
            if (requestBody != null) {
                handler.removeEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", "removeEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findEndpoints";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "findEndpoints");
            List elements = handler.findEndpoints(userId, searchString, "searchString", startFrom, pageSize, "findEndpoints");
            response.setElementList(this.setUpVendorProperties(userId, elements, handler, "findEndpoints"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<EndpointElement> setUpVendorProperties(String userId, List<EndpointElement> retrievedResults, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (EndpointElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private EndpointElement setUpVendorProperties(String userId, EndpointElement element, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            EndpointProperties properties = element.getEndpointProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", methodName));
        }
        return element;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getEndpointsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByName");
            List elements = handler.getEndpointsByName(userId, name, "name", startFrom, pageSize, "getEndpointsByName");
            response.setElementList(this.setUpVendorProperties(userId, elements, handler, "getEndpointsByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String guid) {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointByGUID");
            EndpointElement element = (EndpointElement)handler.getEndpointByGUID(userId, guid, "endpointGUID", "getEndpointByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getEndpointByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

