/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ITInfrastructureOMASConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ContactMethodProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContactMethodConverter<B>
extends ITInfrastructureOMASConverter<B> {
    public ContactMethodConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ContactMethodElement) {
                ContactMethodElement bean = (ContactMethodElement)returnBean;
                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties entityProperties = new InstanceProperties(entity.getProperties());
                    contactMethodProperties.setName(this.removeName(entityProperties));
                    contactMethodProperties.setContactType(this.removeContactType(entityProperties));
                    contactMethodProperties.setContactMethodType(this.getContactMethodTypeFromProperties(entityProperties));
                    contactMethodProperties.setContactMethodService(this.removeContactMethodService(entityProperties));
                    contactMethodProperties.setContactMethodValue(this.removeContactMethodValue(entityProperties));
                    contactMethodProperties.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                    contactMethodProperties.setEffectiveTo(entityProperties.getEffectiveToTime());
                    contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(contactMethodProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

