/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ITProfileElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContactDetailsHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.LoggerFactory;

public class ITProfileRESTServices {
    private static final ITInfrastructureInstanceHandler instanceHandler = new ITInfrastructureInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ITProfileRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createITProfile(String serverName, String userId, ITProfileRequestBody requestBody) {
        String methodName = "createITProfile";
        String profileGUIDParameterName = "profileGUID";
        String userParameterName = "requestBody.getItUserId";
        String itInfrastructureGUIDParameterName = "requestBody.getItInfrastructureGGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createITProfile");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ActorProfileHandler<ITProfileElement> profileHandler = instanceHandler.getITProfileHandler(userId, serverName, "createITProfile");
                UserIdentityHandler<UserIdentityElement> userIdentityHandler = instanceHandler.getUserIdentityHandler(userId, serverName, "createITProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createITProfile");
                EntityDetail userIdentity = userIdentityHandler.getEntityByUniqueQualifiedName(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", requestBody.getItUserId(), "requestBody.getItUserId", false, false, new Date(), "createITProfile");
                String typeName = "ITProfile";
                if (requestBody.getProperties().getTypeName() != null) {
                    typeName = requestBody.getProperties().getTypeName();
                }
                String profileGUID = profileHandler.createActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getKnownName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getAdditionalProperties(), typeName, requestBody.getProperties().getExtendedProperties(), null, null, new Date(), "createITProfile");
                if (userIdentity == null) {
                    userIdentityHandler.createUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), profileGUID, "profileGUID", "UserIdentity:" + requestBody.getItUserId(), requestBody.getItUserId(), null, null, null, null, false, false, new Date(), "createITProfile");
                } else {
                    userIdentityHandler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), profileGUID, "profileGUID", typeName, userIdentity.getGUID(), "requestBody.getItUserId", "UserIdentity", false, false, "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", (InstanceProperties)null, null, null, new Date(), "createITProfile");
                }
                if (requestBody.getItInfrastructureGUID() != null) {
                    profileHandler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getItInfrastructureGUID(), "requestBody.getItInfrastructureGGUID", "Asset", profileGUID, "profileGUID", typeName, false, false, "4c579e3d-a4ff-41c1-9931-33e6fc992f2b", "ITInfrastructureProfile", (InstanceProperties)null, null, null, new Date(), "createITProfile");
                }
                response.setGUID(profileGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createITProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createITProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateITProfile(String serverName, String userId, String itProfileGUID, boolean isMergeUpdate, ITProfileRequestBody requestBody) {
        String methodName = "updateITProfile";
        String guidParameterName = "itProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateITProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "updateITProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateITProfile");
                handler.updateActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), itProfileGUID, "itProfileGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getKnownName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateITProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateITProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateITProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteITProfile(String serverName, String userId, String itProfileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteITProfile";
        String guidParameterName = "itProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteITProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "deleteITProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteITProfile");
                handler.removeActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), itProfileGUID, "itProfileGUID", false, false, new Date(), "deleteITProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteITProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteITProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addContactMethod(String serverName, String userId, String itProfileGUID, ContactMethodRequestBody requestBody) {
        String methodName = "addContactMethod";
        String guidParameterName = "itProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addContactMethod");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ContactDetailsHandler<ContactMethodElement> handler = instanceHandler.getContactDetailsHandler(userId, serverName, "addContactMethod");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addContactMethod");
                int contactMethodTypeOrdinal = 0;
                if (requestBody.getProperties().getContactMethodType() != null) {
                    contactMethodTypeOrdinal = requestBody.getProperties().getContactMethodType().getOpenTypeOrdinal();
                }
                handler.createContactMethod(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), itProfileGUID, "itProfileGUID", requestBody.getProperties().getName(), requestBody.getProperties().getContactType(), contactMethodTypeOrdinal, requestBody.getProperties().getContactMethodService(), requestBody.getProperties().getContactMethodValue(), null, null, false, false, new Date(), "addContactMethod");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addContactMethod", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addContactMethod", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteContactMethod(String serverName, String userId, String contactMethodGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteContactMethod";
        String guidParameterName = "contactMethodGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteContactMethod");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            ContactDetailsHandler<ContactMethodElement> handler = instanceHandler.getContactDetailsHandler(userId, serverName, "deleteContactMethod");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteContactMethod");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), contactMethodGUID, "contactMethodGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deleteContactMethod");
            } else {
                handler.deleteBeanInRepository(userId, null, null, contactMethodGUID, "contactMethodGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deleteContactMethod");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteContactMethod", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ITProfileResponse getITProfileByGUID(String serverName, String userId, String itProfileGUID) {
        String methodName = "getITProfileByGUID";
        String guidParameterName = "itProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getITProfileByGUID");
        ITProfileResponse response = new ITProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "getITProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getITProfileByGUID");
            response.setElement((ITProfileElement)handler.getActorProfileByGUID(userId, itProfileGUID, "itProfileGUID", "ActorProfile", false, false, new Date(), "getITProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getITProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ITProfileResponse getITProfileByUserId(String serverName, String userId, String actorProfileUserId) {
        String methodName = "getITProfileByGUID";
        String nameParameterName = "actorProfileUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getITProfileByGUID");
        ITProfileResponse response = new ITProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "getITProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getITProfileByGUID");
            response.setElement((ITProfileElement)handler.getActorProfileForUser(userId, actorProfileUserId, "actorProfileUserId", "ITProfile", false, false, new Date(), "getITProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getITProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ITProfileListResponse getITProfileByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getITProfileByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getITProfileByName");
        ITProfileListResponse response = new ITProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "getITProfileByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getITProfileByName");
            response.setElements(handler.getActorProfilesByName(userId, requestBody.getName(), "name", "81394f85-6008-465b-926e-b3fae4668937", "ITProfile", startFrom, pageSize, false, false, new Date(), "getITProfileByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getITProfileByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ITProfileListResponse findITProfile(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findITProfile";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findITProfile");
        ITProfileListResponse response = new ITProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ITProfileElement> handler = instanceHandler.getITProfileHandler(userId, serverName, "findITProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findITProfile");
            response.setElements(handler.findActorProfiles(userId, requestBody.getSearchString(), "searchString", "81394f85-6008-465b-926e-b3fae4668937", "ITProfile", startFrom, pageSize, false, false, new Date(), "findITProfile"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findITProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createUserIdentity(String serverName, String userId, UserIdentityRequestBody requestBody) {
        String methodName = "createUserIdentity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createUserIdentity");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "createUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createUserIdentity");
                String userIdentityGUID = handler.createUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getUserId(), requestBody.getProperties().getDistinguishedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), false, false, new Date(), "createUserIdentity");
                response.setGUID(userIdentityGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateUserIdentity(String serverName, String userId, String userIdentityGUID, boolean isMergeUpdate, UserIdentityRequestBody requestBody) {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "updateUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateUserIdentity");
                handler.updateUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getUserId(), requestBody.getProperties().getDistinguishedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateUserIdentity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteUserIdentity(String serverName, String userId, String userIdentityGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "deleteUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteUserIdentity");
                handler.deleteUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", false, false, new Date(), "deleteUserIdentity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addIdentityToProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "addIdentityToProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addIdentityToProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "addIdentityToProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addIdentityToProfile");
                handler.addIdentityToProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", null, null, false, false, new Date(), "addIdentityToProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addIdentityToProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addIdentityToProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeIdentityFromProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeIdentityFromProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeIdentityFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeIdentityFromProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeIdentityFromProfile");
                handler.removeIdentifyFromProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", false, false, new Date(), "removeIdentityFromProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeIdentityFromProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeIdentityFromProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentityListResponse findUserIdentities(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findUserIdentities");
        UserIdentityListResponse response = new UserIdentityListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "findUserIdentities");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findUserIdentities");
                List elements = handler.findBeans(userId, requestBody.getSearchString(), "searchString", "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", null, startFrom, pageSize, false, false, new Date(), "findUserIdentities");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findUserIdentities", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findUserIdentities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentityListResponse getUserIdentitiesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getUserIdentitiesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentitiesByName");
        UserIdentityListResponse response = new UserIdentityListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentitiesByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentitiesByName");
                List elements = handler.getUserIdentitiesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getUserIdentitiesByName");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getUserIdentitiesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentitiesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentityResponse getUserIdentityByGUID(String serverName, String userId, String userIdentityGUID) {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentityByGUID");
        UserIdentityResponse response = new UserIdentityResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentityByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentityByGUID");
            UserIdentityElement element = (UserIdentityElement)handler.getUserIdentityByGUID(userId, userIdentityGUID, "userIdentityGUID", false, false, new Date(), "getUserIdentityByGUID");
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentityByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

