/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementClassification;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementOrigin;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementOriginCategory;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementType;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ITInfrastructureOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public ITInfrastructureOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            return this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName);
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            return elementHeader;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, List<Classification> entityClassifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setClassifications(this.getEntityClassifications(entityClassifications));
            elementHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            return elementHeader;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        if (entityProxy != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", entityProxy.getUniqueProperties(), methodName));
            return elementStub;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, entity, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", entity.getProperties(), methodName));
            return elementStub;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            return elementStub;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    private List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getEntityClassifications(entity.getClassifications());
        }
        return null;
    }

    public Classification getEntityClassification(String classificationName, EntityDetail entity) {
        List classifications;
        if (entity != null && (classifications = entity.getClassifications()) != null) {
            return this.getEntityClassification(classificationName, classifications);
        }
        return null;
    }

    private List<ElementClassification> getEntityClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    protected ElementClassification getClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || !classification.getClassificationName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    private Classification getEntityClassification(String classificationName, List<Classification> classifications) {
        if (classificationName != null && classifications != null) {
            for (Classification classification : classifications) {
                if (classification == null || !classification.getName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    protected List<ElementClassification> removeClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            ArrayList<ElementClassification> results = new ArrayList<ElementClassification>();
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || classification.getClassificationName().equals(classificationName)) continue;
                results.add(classification);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    ElementType getElementType(InstanceHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(instanceType.getTypeDefName());
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }
}

