/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ConnectionConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ConnectorTypeConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ContactMethodConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.EndpointConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ITProfileConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.SoftwareCapabilityConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.UserIdentityConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.ffdc.ITInfrastructureErrorCode;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ITProfileElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContactDetailsHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ITInfrastructureServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.IT_INFRASTRUCTURE_OMAS;
    private ConnectionHandler<ConnectionElement> connectionHandler;
    private ConnectorTypeHandler<ConnectorTypeElement> connectorTypeHandler;
    private EndpointHandler<EndpointElement> endpointHandler;
    private ActorProfileHandler<ITProfileElement> itProfileHandler;
    private UserIdentityHandler<UserIdentityElement> userIdentityHandler;
    private ContactDetailsHandler<ContactMethodElement> contactDetailsHandler;
    private SoftwareCapabilityHandler<SoftwareCapabilityElement> softwareCapabilityHandler;
    private AssetHandler<AssetElement> assetHandler;

    public ITInfrastructureServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, null, null, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(ITInfrastructureErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.connectionHandler = new ConnectionHandler(new ConnectionConverter(this.repositoryHelper, this.serviceName, this.serverName), ConnectionElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler(new ConnectorTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), ConnectorTypeElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.endpointHandler = new EndpointHandler(new EndpointConverter(this.repositoryHelper, this.serviceName, this.serverName), EndpointElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.itProfileHandler = new ActorProfileHandler(new ITProfileConverter(this.repositoryHelper, this.serviceName, this.serverName), ITProfileElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.userIdentityHandler = new UserIdentityHandler(new UserIdentityConverter(this.repositoryHelper, this.serviceName, this.serverName), UserIdentityElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.contactDetailsHandler = new ContactDetailsHandler(new ContactMethodConverter(this.repositoryHelper, this.serviceName, this.serverName), ContactMethodElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.softwareCapabilityHandler = new SoftwareCapabilityHandler(new SoftwareCapabilityConverter(this.repositoryHelper, this.serviceName, this.serverName), SoftwareCapabilityElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        this.assetHandler = new AssetHandler(new AssetConverter(this.repositoryHelper, this.serviceName, this.serverName), AssetElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
    }

    ConnectionHandler<ConnectionElement> getConnectionHandler() throws PropertyServerException {
        String methodName = "getConnectionHandler";
        this.validateActiveRepository("getConnectionHandler");
        return this.connectionHandler;
    }

    ConnectorTypeHandler<ConnectorTypeElement> getConnectorTypeHandler() throws PropertyServerException {
        String methodName = "getConnectorTypeHandler";
        this.validateActiveRepository("getConnectorTypeHandler");
        return this.connectorTypeHandler;
    }

    EndpointHandler<EndpointElement> getEndpointHandler() throws PropertyServerException {
        String methodName = "getEndpointHandler";
        this.validateActiveRepository("getEndpointHandler");
        return this.endpointHandler;
    }

    ActorProfileHandler<ITProfileElement> getITProfileHandler() throws PropertyServerException {
        String methodName = "getITProfileHandler";
        this.validateActiveRepository("getITProfileHandler");
        return this.itProfileHandler;
    }

    UserIdentityHandler<UserIdentityElement> getUserIdentityHandler() throws PropertyServerException {
        String methodName = "getUserIdentityHandler";
        this.validateActiveRepository("getUserIdentityHandler");
        return this.userIdentityHandler;
    }

    ContactDetailsHandler<ContactMethodElement> getContactDetailsHandler() throws PropertyServerException {
        String methodName = "getContactDetailsHandler";
        this.validateActiveRepository("getContactDetailsHandler");
        return this.contactDetailsHandler;
    }

    AssetHandler<AssetElement> getAssetHandler() throws PropertyServerException {
        String methodName = "getAssetHandler";
        this.validateActiveRepository("getAssetHandler");
        return this.assetHandler;
    }

    SoftwareCapabilityHandler<SoftwareCapabilityElement> getSoftwareCapabilityHandler() throws PropertyServerException {
        String methodName = "getSoftwareServerCapabilityHandler";
        this.validateActiveRepository("getSoftwareServerCapabilityHandler");
        return this.softwareCapabilityHandler;
    }
}

