/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.itinfrastructure.converters.ITInfrastructureOMASConverter;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelatedAssetConverter<B>
extends ITInfrastructureOMASConverter<B> {
    public RelatedAssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RelatedAssetElement) {
                RelatedAssetElement bean = (RelatedAssetElement)returnBean;
                if (relationship != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                    if (relationship.getProperties() != null) {
                        bean.setProperties(this.repositoryHelper.getInstancePropertiesAsMap(relationship.getProperties()));
                        bean.setEffectiveFrom(relationship.getProperties().getEffectiveFromTime());
                        bean.setEffectiveTo(relationship.getProperties().getEffectiveToTime());
                    }
                }
                if (entity != null) {
                    AssetElement assetElement = new AssetElement();
                    AssetProperties assetProperties = new AssetProperties();
                    assetElement.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    assetProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    assetProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    assetProperties.setDisplayName(this.removeName(instanceProperties));
                    assetProperties.setDescription(this.removeDescription(instanceProperties));
                    assetProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    assetProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    assetElement.setProperties(assetProperties);
                    bean.setRelatedAsset(assetElement);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

