/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.converters;

import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.PortType;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ServerAssetUseType;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ITInfrastructureOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public ITInfrastructureOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "contactMethodType", properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        return contactMethodType;
    }

    ServerAssetUseType getServerAssetUseTypeFromProperties(InstanceProperties properties) {
        String methodName = "getServerAssetUseTypeFromProperties";
        ServerAssetUseType serverAssetUseType = ServerAssetUseType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "ServerAssetUseType", properties, "getServerAssetUseTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    serverAssetUseType = ServerAssetUseType.OWNS;
                    break;
                }
                case 1: {
                    serverAssetUseType = ServerAssetUseType.GOVERNS;
                    break;
                }
                case 2: {
                    serverAssetUseType = ServerAssetUseType.MAINTAINS;
                    break;
                }
                case 3: {
                    serverAssetUseType = ServerAssetUseType.USES;
                    break;
                }
                case 99: {
                    serverAssetUseType = ServerAssetUseType.OTHER;
                }
            }
        }
        return serverAssetUseType;
    }

    PortType removePortType(InstanceProperties instanceProperties) {
        String methodName = "removePortType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "portType", instanceProperties, "removePortType");
            for (PortType portType : PortType.values()) {
                if (portType.getOpenTypeOrdinal() != ordinal) continue;
                return portType;
            }
        }
        return PortType.OTHER;
    }
}

