/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetExtensionsRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetRelationshipListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.DataFlowRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EffectiveTimeMetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ElementStatusRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.LineageMappingRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.RelatedAssetListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProcessHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedAssetHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.LoggerFactory;

public class ITAssetRESTService {
    private static final ITInfrastructureInstanceHandler instanceHandler = new ITInfrastructureInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ITAssetRESTService.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createAsset(String serverName, String userId, boolean infrastructureManagerIsHome, AssetRequestBody requestBody) {
        String methodName = "createAsset";
        String capabilityGUIDParameterName = "infrastructureManagerGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "createAsset");
            if (requestBody != null) {
                String assetGUID;
                String typeName = OpenMetadataType.ASSET.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                if (infrastructureManagerIsHome) {
                    assetGUID = handler.createAssetInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), this.getInstanceStatus(requestBody.getInitialStatus()), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createAsset");
                    if (assetGUID != null && requestBody.getExternalSourceGUID() != null) {
                        handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getExternalSourceGUID(), "infrastructureManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, null, "createAsset");
                    }
                } else {
                    assetGUID = handler.createAssetInRepository(userId, null, null, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), this.getInstanceStatus(requestBody.getInitialStatus()), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createAsset");
                    if (assetGUID != null && requestBody.getExternalSourceGUID() != null) {
                        handler.linkElementToElement(userId, null, null, requestBody.getExternalSourceGUID(), "infrastructureManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, null, "createAsset");
                    }
                }
                if (assetGUID != null) {
                    handler.setVendorProperties(userId, assetGUID, requestBody.getVendorProperties(), false, false, new Date(), "createAsset");
                }
                response.setGUID(assetGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceStatus getInstanceStatus(ElementStatus status) {
        if (status != null) {
            switch (status) {
                case UNKNOWN: {
                    return InstanceStatus.UNKNOWN;
                }
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case PREPARED: {
                    return InstanceStatus.PREPARED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case REJECTED: {
                    return InstanceStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return InstanceStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return InstanceStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return InstanceStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return InstanceStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return InstanceStatus.STANDBY;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
                case FAILED: {
                    return InstanceStatus.FAILED;
                }
                case DISABLED: {
                    return InstanceStatus.DISABLED;
                }
                case COMPLETE: {
                    return InstanceStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return InstanceStatus.DEPRECATED;
                }
                case OTHER: {
                    return InstanceStatus.OTHER;
                }
            }
        }
        return InstanceStatus.ACTIVE;
    }

    public GUIDResponse createAssetFromTemplate(String serverName, String userId, String templateGUID, boolean infrastructureManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createAssetFromTemplate";
        String capabilityGUIDParameterName = "infrastructureManagerGUID";
        String assetGUIDParameterName = "assetGUID";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAssetFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAssetFromTemplate");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "createAssetFromTemplate");
            if (requestBody != null) {
                String assetGUID = handler.addAssetFromTemplate(userId, handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceName()), templateGUID, "templateGUID", OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getPathName(), requestBody.getNetworkAddress(), false, false, new Date(), "createAssetFromTemplate");
                if (assetGUID != null && requestBody.getExternalSourceGUID() != null) {
                    handler.linkElementToElement(userId, handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceName()), requestBody.getExternalSourceGUID(), "infrastructureManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createAssetFromTemplate");
                }
                response.setGUID(assetGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAssetFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createAssetFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAsset(String serverName, String userId, String assetGUID, boolean isMergeUpdate, AssetRequestBody requestBody) {
        String methodName = "updateAsset";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAsset");
            if (requestBody != null) {
                String typeName = OpenMetadataType.ASSET.typeName;
                if (requestBody.getTypeName() != null) {
                    typeName = requestBody.getTypeName();
                }
                handler.updateAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getAdditionalProperties(), typeName, requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateAsset");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, assetGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateAsset");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetStatus(String serverName, String userId, String assetTypeName, String assetGUID, ElementStatusRequestBody requestBody) {
        String methodName = "updateAssetStatus";
        String assetGUIDParameterName = "assetGUID";
        String statusParameterName = "newStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetStatus");
            if (requestBody != null) {
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetStatus");
                TypeDef typeDef = handler.getTypeDefByName(assetTypeName, OpenMetadataType.ASSET.typeName);
                handler.updateBeanStatusInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", typeDef.getGUID(), typeDef.getName(), false, false, this.getInstanceStatus(requestBody.getElementStatus()), "newStatus", requestBody.getEffectiveTime(), "updateAssetStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAssetStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAssetStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupRelatedAsset(String serverName, String userId, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, String relatedAssetGUID, boolean infrastructureManagerIsHome, AssetExtensionsRequestBody requestBody) {
        String methodName = "setupRelatedAsset";
        String assetGUIDParameterName = "assetGUID";
        String relatedAssetGUIDParameterName = "relatedAssetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupRelatedAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupRelatedAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "setupRelatedAsset");
            if (requestBody != null) {
                TypeDef typeDef = handler.getTypeDefByName(relationshipTypeName, null);
                handler.linkElementToElement(userId, handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceName()), assetGUID, "assetGUID", assetTypeName, relatedAssetGUID, "relatedAssetGUID", relatedAssetTypeName, false, false, typeDef.getGUID(), typeDef.getName(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getEffectiveTime(), "setupRelatedAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupRelatedAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupRelatedAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetRelationship(String serverName, String userId, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, AssetExtensionsRequestBody requestBody) {
        String methodName = "updateAssetRelationship";
        String relationshipGUIDParameterName = "relationshipGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetRelationship");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateAssetRelationship");
            if (requestBody != null) {
                handler.updateElementToElementLink(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, "relationshipGUID", relationshipTypeName, false, false, isMergeUpdate, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getEffectiveTime(), "updateAssetRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAssetRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearRelatedAsset(String serverName, String userId, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, String relatedAssetGUID, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String methodName = "clearRelatedAsset";
        String assetGUIDParameterName = "assetGUID";
        String relatedAssetGUIDParameterName = "relatedAssetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearRelatedAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearRelatedAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "clearRelatedAsset");
            if (requestBody != null) {
                TypeDef relationshipTypeDef = handler.getTypeDefByName(relationshipTypeName, null);
                TypeDef relatedAssetTypeDef = handler.getTypeDefByName(relatedAssetTypeName, OpenMetadataType.ASSET.typeName);
                handler.unlinkElementFromElement(userId, false, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", assetTypeName, relatedAssetGUID, "relatedAssetGUID", relatedAssetTypeDef.getGUID(), relatedAssetTypeName, false, false, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), requestBody.getEffectiveTime(), "clearRelatedAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearRelatedAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearRelatedAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addClassification(String serverName, String userId, String assetTypeName, String assetGUID, String classificationName, boolean infrastructureManagerIsHome, AssetExtensionsRequestBody requestBody) {
        String methodName = "addClassification";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addClassification");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "addClassification");
            if (requestBody != null) {
                TypeDef classificationTypeDef = handler.getTypeDefByName(classificationName, null);
                handler.setClassificationInRepository(userId, handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceGUID()), handler.getExternalSourceID(infrastructureManagerIsHome, requestBody.getExternalSourceName()), assetGUID, "assetGUID", assetTypeName, classificationTypeDef.getGUID(), classificationTypeDef.getName(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, true, requestBody.getProperties(), requestBody.getEffectiveTime(), "addClassification");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addClassification", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassification(String serverName, String userId, String assetTypeName, String assetGUID, String classificationName, boolean isMergeUpdate, AssetExtensionsRequestBody requestBody) {
        String methodName = "updateClassification";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassification");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "updateClassification");
            if (requestBody != null) {
                TypeDef classificationTypeDef = handler.getTypeDefByName(classificationName, null);
                handler.setClassificationInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", assetTypeName, classificationTypeDef.getGUID(), classificationTypeDef.getName(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, isMergeUpdate, requestBody.getProperties(), requestBody.getEffectiveTime(), "updateClassification");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateClassification", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearClassification(String serverName, String userId, String assetTypeName, String assetGUID, String classificationName, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String methodName = "clearClassification";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearClassification");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "clearClassification");
            if (requestBody != null) {
                TypeDef classificationTypeDef = handler.getTypeDefByName(classificationName, null);
                handler.removeClassificationFromRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", assetTypeName, classificationTypeDef.getGUID(), classificationTypeDef.getName(), false, false, requestBody.getEffectiveTime(), "clearClassification");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearClassification", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "publishAsset";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "publishAsset");
            handler.publishAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "publishAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawAsset(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "withdrawAsset";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawAsset");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "withdrawAsset");
            handler.withdrawAsset(userId, assetGUID, "assetGUID", false, false, new Date(), "withdrawAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAsset(String serverName, String userId, String assetGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeAsset";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAsset");
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "removeAsset");
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetGUID, "assetGUID", OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, null, null, false, false, null, "removeAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetListResponse findAssets(String serverName, String userId, String assetTypeName, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findAssets";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AssetListResponse response = new AssetListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            if (requestBody != null) {
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
                TypeDef typeDef = handler.getTypeDefByName(assetTypeName, OpenMetadataType.ASSET.typeName);
                if (typeDef == null) {
                    this.restExceptionHandler.handleBadType(assetTypeName, OpenMetadataType.ASSET.typeName, instanceHandler.getServiceName(), "findAssets");
                } else {
                    List assets = handler.findAssets(userId, typeDef.getGUID(), typeDef.getName(), requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "findAssets");
                    this.setUpVendorProperties(userId, assets, handler, "findAssets");
                    response.setElementList(assets);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetListResponse getAssetsByName(String serverName, String userId, String assetTypeName, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getAssetsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AssetListResponse response = new AssetListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            if (requestBody != null) {
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
                TypeDef typeDef = handler.getTypeDefByName(assetTypeName, OpenMetadataType.ASSET.typeName);
                if (typeDef == null) {
                    this.restExceptionHandler.handleBadType(assetTypeName, OpenMetadataType.ASSET.typeName, instanceHandler.getServiceName(), "getAssetsByName");
                } else {
                    List assets = handler.getAssetsByName(userId, typeDef.getGUID(), typeDef.getName(), requestBody.getName(), "name", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getAssetsByName");
                    this.setUpVendorProperties(userId, assets, handler, "getAssetsByName");
                    response.setElementList(assets);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetListResponse getAssetsForInfrastructureManager(String serverName, String userId, String infrastructureManagerGUID, String infrastructureManagerName, String assetTypeName, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String methodName = "getAssetsForInfrastructureManager";
        String infrastructureManagerGUIDParameterName = "infrastructureManagerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsForInfrastructureManager");
        AssetListResponse response = new AssetListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsForInfrastructureManager");
            if (requestBody != null) {
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsForInfrastructureManager");
                TypeDef typeDef = handler.getTypeDefByName(assetTypeName, OpenMetadataType.ASSET.typeName);
                if (typeDef == null) {
                    this.restExceptionHandler.handleBadType(assetTypeName, OpenMetadataType.ASSET.typeName, instanceHandler.getServiceName(), "getAssetsForInfrastructureManager");
                } else {
                    List assets = handler.getAttachedElements(userId, infrastructureManagerGUID, "infrastructureManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, typeDef.getName(), null, null, 2, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getAssetsForInfrastructureManager");
                    this.setUpVendorProperties(userId, assets, handler, "getAssetsForInfrastructureManager");
                    response.setElementList(assets);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsForInfrastructureManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetsForInfrastructureManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetResponse getAssetByGUID(String serverName, String userId, String assetTypeName, String guid, EffectiveTimeRequestBody requestBody) {
        String methodName = "getAssetByGUID";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetByGUID");
        AssetResponse response = new AssetResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetByGUID");
            if (requestBody != null) {
                AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetByGUID");
                TypeDef typeDef = handler.getTypeDefByName(assetTypeName, OpenMetadataType.ASSET.typeName);
                if (typeDef == null) {
                    this.restExceptionHandler.handleBadType(assetTypeName, OpenMetadataType.ASSET.typeName, instanceHandler.getServiceName(), "getAssetByGUID");
                } else {
                    AssetElement assetAsset = (AssetElement)handler.getBeanFromRepository(userId, guid, "guid", typeDef.getName(), false, false, requestBody.getEffectiveTime(), "getAssetByGUID");
                    response.setElement(this.setUpVendorProperties(userId, assetAsset, handler, "getAssetByGUID"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetRelationshipListResponse getAssetRelationships(String serverName, String userId, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, int startingEnd, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        return null;
    }

    public RelatedAssetListResponse getRelatedAssets(String serverName, String userId, String assetTypeName, String assetGUID, String relationshipTypeName, String relatedAssetTypeName, int startingEnd, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String methodName = "getRelatedAssets";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssets");
        RelatedAssetListResponse response = new RelatedAssetListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssets");
            if (requestBody != null) {
                List assets;
                RelatedAssetHandler<RelatedAssetElement> handler = instanceHandler.getRelatedAssetHandler(userId, serverName, "getRelatedAssets");
                TypeDef typeDef = handler.getTypeDefByName(relationshipTypeName, null);
                String typeGUID = null;
                String typeName = null;
                if (typeDef != null) {
                    typeGUID = typeDef.getGUID();
                    typeName = typeDef.getName();
                }
                if ((assets = handler.getRelatedAssets(userId, assetGUID, "assetGUID", assetTypeName, typeGUID, typeName, relatedAssetTypeName, instanceHandler.getSupportedZones(userId, serverName, "getRelatedAssets"), startingEnd, startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getRelatedAssets")) != null) {
                    AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getRelatedAssets");
                    for (RelatedAssetElement element : assets) {
                        AssetElement assetElement;
                        if (element == null || (assetElement = element.getRelatedAsset()) == null) continue;
                        this.setUpVendorProperties(userId, assetElement, assetHandler, "getRelatedAssets");
                    }
                }
                response.setElementList(assets);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getRelatedAssets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private AssetElement setUpVendorProperties(String userId, AssetElement element, AssetHandler<AssetElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            AssetProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private void setUpVendorProperties(String userId, List<AssetElement> retrievedResults, AssetHandler<AssetElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (AssetElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
    }

    public GUIDResponse setupDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, boolean infrastructureManagerIsHome, DataFlowRequestBody requestBody) {
        String methodName = "setupDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupDataFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupDataFlow");
            if (requestBody != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "setupDataFlow");
                if (requestBody.getProperties() != null) {
                    if (infrastructureManagerIsHome) {
                        response.setGUID(handler.setupDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, new Date(), "setupDataFlow"));
                    } else {
                        response.setGUID(handler.setupDataFlow(userId, null, null, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, new Date(), "setupDataFlow"));
                    }
                } else {
                    response.setGUID(handler.setupDataFlow(userId, null, null, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", null, null, null, null, null, false, false, new Date(), "setupDataFlow"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupDataFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementResponse getDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, NameRequestBody requestBody) {
        String methodName = "getDataFlow";
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlow");
        DataFlowElementResponse response = new DataFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlow");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getDataFlow");
            if (requestBody != null) {
                response.setElement((DataFlowElement)handler.getDataFlow(userId, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", requestBody.getName(), false, false, requestBody.getEffectiveTime(), "getDataFlow"));
            } else {
                response.setElement((DataFlowElement)handler.getDataFlow(userId, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", null, false, false, new Date(), "getDataFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataFlow(String serverName, String userId, String dataFlowGUID, DataFlowRequestBody requestBody) {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        String methodName = "updateDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataFlow");
            if (requestBody != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "updateDataFlow");
                if (requestBody.getProperties() != null) {
                    handler.updateDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFlowGUID, "dataFlowGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, requestBody.getEffectiveTime(), "updateDataFlow");
                } else {
                    handler.updateDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFlowGUID, "dataFlowGUID", null, null, null, null, null, false, false, new Date(), "updateDataFlow");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDataFlow(String serverName, String userId, String dataFlowGUID, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        String methodName = "clearDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearDataFlow");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "clearDataFlow");
            if (requestBody != null) {
                handler.clearDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFlowGUID, "dataFlowGUID", false, false, requestBody.getEffectiveTime(), "clearDataFlow");
            } else {
                handler.clearDataFlow(userId, null, null, dataFlowGUID, "dataFlowGUID", false, false, new Date(), "clearDataFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowConsumers(String serverName, String userId, String dataSupplierGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String methodName = "getDataFlowConsumers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowConsumers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowConsumers");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getDataFlowConsumers");
            if (requestBody != null) {
                response.setElementList(handler.getDataFlowConsumers(userId, dataSupplierGUID, "dataSupplierGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getDataFlowConsumers"));
            } else {
                response.setElementList(handler.getDataFlowConsumers(userId, dataSupplierGUID, "dataSupplierGUID", startFrom, pageSize, false, false, new Date(), "getDataFlowConsumers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlowConsumers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowSuppliers(String serverName, String userId, String dataConsumerGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        String methodName = "getDataFlowSuppliers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowSuppliers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowSuppliers");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getDataFlowSuppliers");
            if (requestBody != null) {
                response.setElementList(handler.getDataFlowSuppliers(userId, dataConsumerGUID, "dataConsumerGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getDataFlowSuppliers"));
            } else {
                response.setElementList(handler.getDataFlowSuppliers(userId, dataConsumerGUID, "dataConsumerGUID", startFrom, pageSize, false, false, new Date(), "getDataFlowSuppliers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlowSuppliers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, boolean infrastructureManagerIsHome, ControlFlowRequestBody requestBody) {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        String methodName = "setupControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupControlFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupControlFlow");
            if (requestBody != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "setupControlFlow");
                if (requestBody.getProperties() != null) {
                    if (infrastructureManagerIsHome) {
                        response.setGUID(handler.setupControlFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getGuard(), false, false, requestBody.getEffectiveTime(), "setupControlFlow"));
                    } else {
                        response.setGUID(handler.setupControlFlow(userId, null, null, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getGuard(), false, false, requestBody.getEffectiveTime(), "setupControlFlow"));
                    }
                } else {
                    response.setGUID(handler.setupControlFlow(userId, null, null, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", null, null, null, null, null, false, false, new Date(), "setupControlFlow"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupControlFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementResponse getControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, NameRequestBody requestBody) {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        String methodName = "getControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlow");
        ControlFlowElementResponse response = new ControlFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlow");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getControlFlow");
            if (requestBody != null) {
                response.setElement((ControlFlowElement)handler.getControlFlow(userId, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", requestBody.getName(), false, false, requestBody.getEffectiveTime(), "getControlFlow"));
            } else {
                response.setElement((ControlFlowElement)handler.getControlFlow(userId, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", null, false, false, new Date(), "getControlFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateControlFlow(String serverName, String userId, String controlFlowGUID, ControlFlowRequestBody requestBody) {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        String methodName = "updateControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateControlFlow");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "updateControlFlow");
                handler.updateControlFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), controlFlowGUID, "controlFlowGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getGuard(), false, false, requestBody.getEffectiveTime(), "updateControlFlow");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateControlFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearControlFlow(String serverName, String userId, String controlFlowGUID, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        String methodName = "clearControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearControlFlow");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "clearControlFlow");
            if (requestBody != null) {
                handler.clearControlFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), controlFlowGUID, "controlFlowGUID", false, false, requestBody.getEffectiveTime(), "clearControlFlow");
            } else {
                handler.clearControlFlow(userId, null, null, controlFlowGUID, "controlFlowGUID", false, false, new Date(), "clearControlFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowNextSteps(String serverName, String userId, String currentStepGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String currentStepGUIDParameterName = "currentStepGUID";
        String methodName = "getControlFlowNextSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowNextSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowNextSteps");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getControlFlowNextSteps");
            if (requestBody != null) {
                response.setElementList(handler.getControlFlowNextSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getControlFlowNextSteps"));
            } else {
                response.setElementList(handler.getControlFlowNextSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, false, false, new Date(), "getControlFlowNextSteps"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlowNextSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowPreviousSteps(String serverName, String userId, String currentStepGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String currentStepGUIDParameterName = "currentStepGUID";
        String methodName = "getControlFlowPreviousSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowPreviousSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowPreviousSteps");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getControlFlowPreviousSteps");
            if (requestBody != null) {
                response.setElementList(handler.getControlFlowPreviousSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getControlFlowPreviousSteps"));
            } else {
                response.setElementList(handler.getControlFlowPreviousSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, false, false, new Date(), "getControlFlowPreviousSteps"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlowPreviousSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupProcessCall(String serverName, String userId, String callerGUID, String calledGUID, boolean infrastructureManagerIsHome, ProcessCallRequestBody requestBody) {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        String methodName = "setupProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessCall");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessCall");
            if (requestBody != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "setupProcessCall");
                if (requestBody.getProperties() != null) {
                    if (infrastructureManagerIsHome) {
                        response.setGUID(handler.setupProcessCall(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), callerGUID, "callerGUID", calledGUID, "calledGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, requestBody.getEffectiveTime(), "setupProcessCall"));
                    } else {
                        response.setGUID(handler.setupProcessCall(userId, null, null, callerGUID, "callerGUID", calledGUID, "calledGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, requestBody.getEffectiveTime(), "setupProcessCall"));
                    }
                } else {
                    response.setGUID(handler.setupProcessCall(userId, null, null, callerGUID, "callerGUID", calledGUID, "calledGUID", null, null, null, null, null, false, false, new Date(), "setupProcessCall"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupProcessCall", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementResponse getProcessCall(String serverName, String userId, String callerGUID, String calledGUID, NameRequestBody requestBody) {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        String methodName = "getProcessCallers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCallers");
        ProcessCallElementResponse response = new ProcessCallElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCallers");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getProcessCallers");
            if (requestBody != null) {
                response.setElement((ProcessCallElement)handler.getProcessCall(userId, callerGUID, "callerGUID", calledGUID, "calledGUID", requestBody.getName(), false, false, requestBody.getEffectiveTime(), "getProcessCallers"));
            } else {
                response.setElement((ProcessCallElement)handler.getProcessCall(userId, callerGUID, "callerGUID", calledGUID, "calledGUID", null, false, false, new Date(), "getProcessCallers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCallers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcessCall(String serverName, String userId, String processCallGUID, ProcessCallRequestBody requestBody) {
        String processCallGUIDParameterName = "processCallGUID";
        String methodName = "updateProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcessCall");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "updateProcessCall");
                handler.updateProcessCall(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), processCallGUID, "processCallGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), false, false, requestBody.getEffectiveTime(), "updateProcessCall");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcessCall", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessCall(String serverName, String userId, String processCallGUID, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String processCallGUIDParameterName = "processCallGUID";
        String methodName = "clearProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessCall");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "clearProcessCall");
            if (requestBody != null) {
                handler.clearProcessCall(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), processCallGUID, "processCallGUID", false, false, requestBody.getEffectiveTime(), "clearProcessCall");
            } else {
                handler.clearProcessCall(userId, null, null, processCallGUID, "processCallGUID", false, false, new Date(), "clearProcessCall");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCalled(String serverName, String userId, String callerGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String callerGUIDParameterName = "callerGUID";
        String methodName = "getProcessCalled";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCalled");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCalled");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getProcessCalled");
            if (requestBody != null) {
                response.setElementList(handler.getProcessCalled(userId, callerGUID, "callerGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getProcessCalled"));
            } else {
                response.setElementList(handler.getProcessCalled(userId, callerGUID, "callerGUID", startFrom, pageSize, false, false, new Date(), "getProcessCalled"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCalled", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCallers(String serverName, String userId, String calledGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String callerGUIDParameterName = "callerGUID";
        String methodName = "getProcessCallers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCallers");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCallers");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getProcessCallers");
            if (requestBody != null) {
                response.setElementList(handler.getProcessCallers(userId, calledGUID, "callerGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getProcessCallers"));
            } else {
                response.setElementList(handler.getProcessCallers(userId, calledGUID, "callerGUID", startFrom, pageSize, false, false, new Date(), "getProcessCallers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCallers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, LineageMappingRequestBody requestBody) {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        String methodName = "setupLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupLineageMapping");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "setupLineageMapping");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, requestBody.getEffectiveTime(), "setupLineageMapping");
                } else {
                    handler.setupLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", null, null, null, null, false, false, requestBody.getEffectiveTime(), "setupLineageMapping");
                }
            } else {
                handler.setupLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", null, null, null, null, false, false, new Date(), "setupLineageMapping");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementResponse getLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, NameRequestBody requestBody) {
        String methodName = "getLineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLineageMapping");
        LineageMappingElementResponse response = new LineageMappingElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLineageMapping");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getLineageMapping");
            if (requestBody != null) {
                response.setElement((LineageMappingElement)handler.getLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", requestBody.getName(), false, false, requestBody.getEffectiveTime(), "getLineageMapping"));
            } else {
                response.setElement((LineageMappingElement)handler.getLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", null, false, false, new Date(), "getLineageMapping"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLineageMapping(String serverName, String userId, String lineageMappingGUID, EffectiveTimeMetadataSourceRequestBody requestBody) {
        String lineageMappingGUIDParameterName = "lineageMappingGUID";
        String methodName = "clearLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLineageMapping");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "clearLineageMapping");
            if (requestBody != null) {
                handler.clearLineageMapping(userId, lineageMappingGUID, "lineageMappingGUID", false, false, requestBody.getEffectiveTime(), "clearLineageMapping");
            } else {
                handler.clearLineageMapping(userId, lineageMappingGUID, "lineageMappingGUID", false, false, new Date(), "clearLineageMapping");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getDestinationLineageMappings(String serverName, String userId, String sourceElementGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String methodName = "getDestinationLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDestinationLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDestinationLineageMappings");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getDestinationLineageMappings");
            if (requestBody != null) {
                response.setElementList(handler.getDestinationLineageMappings(userId, sourceElementGUID, "sourceElementGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getDestinationLineageMappings"));
            } else {
                response.setElementList(handler.getDestinationLineageMappings(userId, sourceElementGUID, "sourceElementGUID", startFrom, pageSize, false, false, new Date(), "getDestinationLineageMappings"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDestinationLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getSourceLineageMappings(String serverName, String userId, String destinationElementGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String destinationElementGUIDParameterName = "destinationElementGUID";
        String methodName = "getSourceLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSourceLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceLineageMappings");
            ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> handler = instanceHandler.getProcessHandler(userId, serverName, "getSourceLineageMappings");
            if (requestBody != null) {
                response.setElementList(handler.getSourceLineageMappings(userId, destinationElementGUID, "destinationElementGUID", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getSourceLineageMappings"));
            } else {
                response.setElementList(handler.getSourceLineageMappings(userId, destinationElementGUID, "destinationElementGUID", startFrom, pageSize, false, false, new Date(), "getSourceLineageMappings"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSourceLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

