/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.outtopic;

import org.odpi.openmetadata.accessservices.itinfrastructure.connectors.outtopic.ITInfrastructureOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.itinfrastructure.events.ITInfrastructureEventType;
import org.odpi.openmetadata.accessservices.itinfrastructure.events.ITInfrastructureOutTopicEvent;
import org.odpi.openmetadata.accessservices.itinfrastructure.ffdc.ITInfrastructureAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ITInfrastructureOutTopicPublisher {
    private final ITInfrastructureOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final ElementHeaderConverter<ElementHeader> headerConverter;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public ITInfrastructureOutTopicPublisher(ITInfrastructureOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        this.repositoryHelper = repositoryHelper;
        this.headerConverter = new ElementHeaderConverter(repositoryHelper, serviceName, serverName);
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", ITInfrastructureAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    public void publishEntityEvent(EntityDetail entity, ITInfrastructureEventType eventType) {
        this.publishEntityEvent(eventType, entity, null, null, null);
    }

    public void publishEntityEvent(ITInfrastructureEventType eventType, EntityDetail entity, EntityDetail previousEntity, Classification newClassification, Classification previousClassification) {
        String methodName = "publishEntityEvent";
        if (this.outTopicServerConnector != null) {
            ITInfrastructureOutTopicEvent event = new ITInfrastructureOutTopicEvent();
            try {
                event.setEventType(eventType);
                if (entity.getUpdateTime() == null) {
                    event.setEventTime(entity.getCreateTime());
                } else {
                    event.setEventTime(entity.getUpdateTime());
                }
                event.setElementHeader((ElementHeader)this.headerConverter.getNewBean(ElementHeader.class, entity, "publishEntityEvent"));
                event.setElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(entity.getProperties()));
                if (previousEntity != null) {
                    event.setPreviousElementHeader((ElementHeader)this.headerConverter.getNewBean(ElementHeader.class, previousEntity, "publishEntityEvent"));
                    event.setPreviousElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousEntity.getProperties()));
                }
                if (newClassification != null) {
                    event.setClassificationName(newClassification.getName());
                }
                if (previousClassification != null) {
                    event.setClassificationName(previousClassification.getName());
                    event.setPreviousClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousClassification.getProperties()));
                }
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                this.outTopicAuditLog.logException("publishEntityEvent", ITInfrastructureAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.toString(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", ITInfrastructureAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", ITInfrastructureAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

