/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUseRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUseResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ServerAssetUsesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareCapabilityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UseTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ElementStubConverter;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EndpointElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ServerAssetUseElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.ServerAssetUseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.SoftwareCapabilityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.LoggerFactory;

public class ITInfrastructureRESTServices {
    private static final ITInfrastructureInstanceHandler instanceHandler = new ITInfrastructureInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ITInfrastructureRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnection(String serverName, String userId, ConnectionRequestBody requestBody) {
        String methodName = "createConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnection");
            if (requestBody != null) {
                String connectionGUID = handler.createConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, null, null, null, null, false, false, handler.getSupportedZones(), new Date(), "createConnection");
                if (connectionGUID != null) {
                    handler.setVendorProperties(userId, connectionGUID, requestBody.getVendorProperties(), false, false, new Date(), "createConnection");
                }
                response.setGUID(connectionGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectionFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectionFromTemplate");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnectionFromTemplate");
            if (requestBody != null) {
                String connectionGUID = handler.createConnectionFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, "templateGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), "createConnectionFromTemplate");
                response.setGUID(connectionGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnection(String serverName, String userId, String connectionGUID, boolean isMergeUpdate, ConnectionRequestBody requestBody) {
        String methodName = "updateConnection";
        String connectionGUIDParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "updateConnection");
            if (requestBody != null) {
                handler.updateConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateConnection");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, connectionGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateConnection");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupConnectorType");
            if (requestBody != null) {
                handler.addConnectionConnectorType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", null, null, false, false, new Date(), "setupConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearConnectorType");
            if (requestBody != null) {
                handler.removeConnectionConnectorType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "clearConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEndpoint");
            if (requestBody != null) {
                handler.addConnectionEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", null, null, false, false, new Date(), "setupEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEndpoint");
            if (requestBody != null) {
                handler.removeConnectionEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", false, false, new Date(), "clearEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionRequestBody requestBody) {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEmbeddedConnection");
            if (requestBody != null) {
                handler.addEmbeddedConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", requestBody.getPosition(), requestBody.getDisplayName(), requestBody.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID", null, null, false, false, handler.getSupportedZones(), new Date(), "setupEmbeddedConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEmbeddedConnection");
            if (requestBody != null) {
                handler.removeEmbeddedConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", embeddedConnectionGUID, "embeddedConnectionGUID", false, false, handler.getSupportedZones(), new Date(), "clearEmbeddedConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, AssetConnectionRequestBody requestBody) {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupAssetConnection");
            if (requestBody != null) {
                handler.addConnectionToAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", assetGUID, "assetGUID", requestBody.getAssetSummary(), null, null, false, false, new Date(), "setupAssetConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearAssetConnection");
            if (requestBody != null) {
                handler.removeConnectionToAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", assetGUID, "assetGUID", false, false, new Date(), "clearAssetConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnection(String serverName, String userId, String connectionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeConnection";
        String connectionGUIDParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnection");
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "removeConnection");
                handler.removeConnection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectionGUID, "connectionGUID", false, false, new Date(), "removeConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse findConnections(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnections";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnections");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "findConnections");
                List connections = handler.findConnections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnections");
                response.setElements(this.setUpVendorProperties(userId, connections, handler, "findConnections"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnections", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsByName");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsByName");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionsByName");
                List connections = handler.getConnectionsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectionsByName");
                response.setElements(this.setUpVendorProperties(userId, connections, handler, "getConnectionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String guid) {
        String methodName = "getConnectionByGUID";
        String guidParameterName = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            ConnectionElement connection = (ConnectionElement)handler.getConnectionByGUID(userId, guid, "connectionGUID", false, false, new Date(), "getConnectionByGUID");
            response.setElement(this.setUpVendorProperties(userId, connection, handler, "getConnectionByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorType(String serverName, String userId, ConnectorTypeRequestBody requestBody) {
        String methodName = "createConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorType");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "createConnectorType");
            if (requestBody != null) {
                String connectorTypeGUID = handler.createConnectorType(userId, null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getSupportedAssetTypeName(), null, requestBody.getExpectedDataFormat(), requestBody.getConnectorProviderClassName(), requestBody.getConnectorFrameworkName(), requestBody.getConnectorInterfaceLanguage(), requestBody.getConnectorInterfaces(), requestBody.getTargetTechnologySource(), requestBody.getTargetTechnologyName(), requestBody.getTargetTechnologyInterfaces(), requestBody.getTargetTechnologyVersions(), requestBody.getRecognizedAdditionalProperties(), requestBody.getRecognizedSecuredProperties(), requestBody.getRecognizedConfigurationProperties(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), new Date(), "createConnectorType");
                if (connectorTypeGUID != null) {
                    handler.setVendorProperties(userId, connectorTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "createConnectorType");
                }
                response.setGUID(connectorTypeGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorTypeFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createConnectorTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorTypeFromTemplate");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "createConnectorTypeFromTemplate");
            if (requestBody != null) {
                String connectorTypeGUID = handler.createConnectorTypeFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), "createConnectorTypeFromTemplate");
                response.setGUID(connectorTypeGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectorTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnectorType(String serverName, String userId, String connectorTypeGUID, boolean isMergeUpdate, ConnectorTypeRequestBody requestBody) {
        String methodName = "updateConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnectorType");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "updateConnectorType");
            if (requestBody != null) {
                handler.updateConnectorType(userId, null, null, connectorTypeGUID, "connectorTypeGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getSupportedAssetTypeName(), null, requestBody.getExpectedDataFormat(), requestBody.getConnectorProviderClassName(), requestBody.getConnectorFrameworkName(), requestBody.getConnectorInterfaceLanguage(), requestBody.getConnectorInterfaces(), requestBody.getTargetTechnologySource(), requestBody.getTargetTechnologyName(), requestBody.getTargetTechnologyInterfaces(), requestBody.getTargetTechnologyVersions(), requestBody.getRecognizedAdditionalProperties(), requestBody.getRecognizedSecuredProperties(), requestBody.getRecognizedConfigurationProperties(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateConnectorType");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, connectorTypeGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateConnectorType");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnectorType(String serverName, String userId, String connectorTypeGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeConnectorType";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnectorType");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "removeConnectorType");
            if (requestBody != null) {
                handler.removeConnectorType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "removeConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse findConnectorTypes(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnectorTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnectorTypes");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnectorTypes");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "findConnectorTypes");
                List elements = handler.findConnectorTypes(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnectorTypes");
                response.setElements(this.setUpVendorProperties(userId, elements, handler, "findConnectorTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnectorTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnectorTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectorTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesByName");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesByName");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypesByName");
                List elements = handler.getConnectorTypesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectorTypesByName");
                response.setElements(this.setUpVendorProperties(userId, elements, handler, "getConnectorTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectorTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorTypeByGUID(String serverName, String userId, String guid) {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypeByGUID");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeElement element = (ConnectorTypeElement)handler.getConnectorTypeByGUID(userId, guid, "connectorTypeGUID", false, false, new Date(), "getConnectorTypeByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getConnectorTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpoint(String serverName, String userId, String infrastructureGUID, EndpointRequestBody requestBody) {
        String methodName = "createEndpoint";
        String infrastructureGUIDParameterName = "infrastructureGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpoint");
            if (requestBody != null) {
                String endpointGUID = handler.createEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, new Date(), "createEndpoint");
                if (endpointGUID != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), false, false, new Date(), "createEndpoint");
                }
                if (infrastructureGUID != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, "infrastructureGUID", OpenMetadataType.IT_INFRASTRUCTURE.typeName, endpointGUID, "endpointGUID", OpenMetadataType.ENDPOINT.typeName, false, false, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, new Date(), "createEndpoint");
                }
                response.setGUID(endpointGUID);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String infrastructureGUID, String networkAddress, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createEndpointFromTemplate";
        String infrastructureGUIDParameterName = "infrastructureGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpointFromTemplate");
            if (requestBody != null) {
                String endpointGUID = handler.createEndpointFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), networkAddress, "createEndpointFromTemplate");
                if (infrastructureGUID != null) {
                    handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), infrastructureGUID, "infrastructureGUID", OpenMetadataType.IT_INFRASTRUCTURE.typeName, endpointGUID, "endpointGUID", OpenMetadataType.ENDPOINT.typeName, false, false, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, (InstanceProperties)null, null, null, null, "createEndpointFromTemplate");
                }
                response.setGUID(endpointGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, EndpointRequestBody requestBody) {
        String methodName = "updateEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "updateEndpoint");
            if (requestBody != null) {
                handler.updateEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", requestBody.getQualifiedName(), requestBody.getName(), requestBody.getResourceDescription(), requestBody.getAddress(), requestBody.getProtocol(), requestBody.getEncryptionMethod(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateEndpoint");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, endpointGUID, requestBody.getVendorProperties(), false, false, new Date(), "updateEndpoint");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeEndpoint";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "removeEndpoint");
            if (requestBody != null) {
                handler.removeEndpoint(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), endpointGUID, "endpointGUID", false, false, new Date(), "removeEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "findEndpoints");
                List endpoints = handler.findEndpoints(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findEndpoints");
                response.setElements(this.setUpVendorProperties(userId, endpoints, handler, "findEndpoints"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEndpointsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByName");
                List endpoints = handler.getEndpointsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getEndpointsByName");
                response.setElements(this.setUpVendorProperties(userId, endpoints, handler, "getEndpointsByName"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByNetworkAddress(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEndpointsByNetworkAddress";
        String parameterName = "networkAddress";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByNetworkAddress");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByNetworkAddress");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByNetworkAddress");
                List endpoints = handler.getEndpointsByNetworkAddress(userId, requestBody.getName(), "networkAddress", startFrom, pageSize, false, false, new Date(), "getEndpointsByNetworkAddress");
                response.setElements(this.setUpVendorProperties(userId, endpoints, handler, "getEndpointsByNetworkAddress"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByNetworkAddress", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsForInfrastructure(String serverName, String userId, String infrastructureGUID, int startFrom, int pageSize) {
        String methodName = "getEndpointsForInfrastructure";
        String guidParameterName = "infrastructureGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsForInfrastructure");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsForInfrastructure");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsForInfrastructure");
            List endpoints = handler.getAttachedElements(userId, infrastructureGUID, "infrastructureGUID", OpenMetadataType.IT_INFRASTRUCTURE.typeName, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, OpenMetadataType.ENDPOINT.typeName, null, null, 0, false, false, startFrom, pageSize, new Date(), "getEndpointsForInfrastructure");
            response.setElements(this.setUpVendorProperties(userId, endpoints, handler, "getEndpointsForInfrastructure"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsForInfrastructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String guid) {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointByGUID");
            EndpointElement element = (EndpointElement)handler.getEndpointByGUID(userId, guid, "endpointGUID", false, false, new Date(), "getEndpointByGUID");
            response.setElement(this.setUpVendorProperties(userId, element, handler, "getEndpointByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<ConnectionElement> setUpVendorProperties(String userId, List<ConnectionElement> retrievedResults, ConnectionHandler<ConnectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ConnectionElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ConnectionElement setUpVendorProperties(String userId, ConnectionElement element, ConnectionHandler<ConnectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ConnectionProperties properties = element.getConnectionProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<EndpointElement> setUpVendorProperties(String userId, List<EndpointElement> retrievedResults, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (EndpointElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private EndpointElement setUpVendorProperties(String userId, EndpointElement element, EndpointHandler<EndpointElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            EndpointProperties properties = element.getEndpointProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    private List<ConnectorTypeElement> setUpVendorProperties(String userId, List<ConnectorTypeElement> retrievedResults, ConnectorTypeHandler<ConnectorTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ConnectorTypeElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ConnectorTypeElement setUpVendorProperties(String userId, ConnectorTypeElement element, ConnectorTypeHandler<ConnectorTypeElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ConnectorTypeProperties properties = element.getConnectorTypeProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    public GUIDResponse createSoftwareCapability(String serverName, String userId, boolean infrastructureManagerIsHome, SoftwareCapabilityRequestBody requestBody) {
        String methodName = "createSoftwareCapability";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSoftwareCapability");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSoftwareCapability");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "createSoftwareCapability");
            if (requestBody != null) {
                String capabilityGUID = infrastructureManagerIsHome ? handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getClassificationName(), requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, new Date(), "createSoftwareCapability") : handler.createSoftwareCapability(userId, null, null, requestBody.getTypeName(), requestBody.getClassificationName(), requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, new Date(), "createSoftwareCapability");
                response.setGUID(capabilityGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSoftwareCapability", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSoftwareCapability", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSoftwareCapabilityFromTemplate(String serverName, String userId, String templateGUID, boolean infrastructureManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createSoftwareCapabilityFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSoftwareCapabilityFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSoftwareCapabilityFromTemplate");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "createSoftwareCapabilityFromTemplate");
            if (requestBody != null) {
                String capabilityGUID = infrastructureManagerIsHome ? handler.createSoftwareCapabilityFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, "templateGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), "createSoftwareCapabilityFromTemplate") : handler.createSoftwareCapabilityFromTemplate(userId, null, null, templateGUID, "templateGUID", requestBody.getQualifiedName(), "qualifiedName", requestBody.getDisplayName(), requestBody.getDescription(), "createSoftwareCapabilityFromTemplate");
                response.setGUID(capabilityGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSoftwareCapabilityFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSoftwareCapabilityFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSoftwareCapability(String serverName, String userId, String capabilityGUID, boolean isMergeUpdate, SoftwareCapabilityRequestBody requestBody) {
        String methodName = "updateSoftwareCapability";
        String elementGUIDParameterName = "capabilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSoftwareCapability");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSoftwareCapability");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "updateSoftwareCapability");
            if (requestBody != null) {
                Date effectiveDate = new Date();
                handler.updateSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), capabilityGUID, "capabilityGUID", requestBody.getQualifiedName(), requestBody.getResourceName(), requestBody.getResourceDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), isMergeUpdate, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, effectiveDate, "updateSoftwareCapability");
                if (!isMergeUpdate || requestBody.getVendorProperties() != null) {
                    handler.setVendorProperties(userId, capabilityGUID, requestBody.getVendorProperties(), false, false, effectiveDate, "updateSoftwareCapability");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSoftwareCapability", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateSoftwareCapability", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSoftwareCapability(String serverName, String userId, String capabilityGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeSoftwareCapability";
        String elementGUIDParameterName = "capabilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSoftwareCapability");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSoftwareCapability");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "removeSoftwareCapability");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), capabilityGUID, "capabilityGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, null, false, false, null, "removeSoftwareCapability");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSoftwareCapability", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSoftwareCapability", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareCapabilitiesResponse findSoftwareCapabilities(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSoftwareCapabilities";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSoftwareCapabilities");
        SoftwareCapabilitiesResponse response = new SoftwareCapabilitiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSoftwareCapabilities");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "findSoftwareCapabilities");
                List capabilities = handler.findBeans(userId, requestBody.getSearchString(), "searchString", OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, startFrom, pageSize, false, false, new Date(), "findSoftwareCapabilities");
                response.setElements(this.setUpVendorProperties(userId, capabilities, handler, "findSoftwareCapabilities"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findSoftwareCapabilities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareCapabilitiesResponse getSoftwareCapabilitiesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getSoftwareCapabilitiesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSoftwareCapabilitiesByName");
        SoftwareCapabilitiesResponse response = new SoftwareCapabilitiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSoftwareCapabilitiesByName");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getSoftwareCapabilitiesByName");
                ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
                specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
                specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
                specificMatchPropertyNames.add(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
                specificMatchPropertyNames.add(OpenMetadataProperty.CAPABILITY_TYPE.name);
                List capabilities = handler.getBeansByValue(userId, requestBody.getName(), "name", OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, specificMatchPropertyNames, true, null, null, false, false, null, startFrom, pageSize, new Date(), "getSoftwareCapabilitiesByName");
                response.setElements(this.setUpVendorProperties(userId, capabilities, handler, "getSoftwareCapabilitiesByName"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSoftwareCapabilitiesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareCapabilityResponse getSoftwareCapabilityByGUID(String serverName, String userId, String guid) {
        String methodName = "getSoftwareCapabilityByGUID";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSoftwareCapabilityByGUID");
        SoftwareCapabilityResponse response = new SoftwareCapabilityResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSoftwareCapabilityByGUID");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getSoftwareCapabilityByGUID");
            SoftwareCapabilityElement capability = (SoftwareCapabilityElement)handler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, false, false, new Date(), "getSoftwareCapabilityByGUID");
            response.setElement(this.setUpVendorProperties(userId, capability, handler, "getSoftwareCapabilityByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSoftwareCapabilityByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<SoftwareCapabilityElement> setUpVendorProperties(String userId, List<SoftwareCapabilityElement> retrievedResults, SoftwareCapabilityHandler<SoftwareCapabilityElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (SoftwareCapabilityElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private SoftwareCapabilityElement setUpVendorProperties(String userId, SoftwareCapabilityElement element, SoftwareCapabilityHandler<SoftwareCapabilityElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            SoftwareCapabilityProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }

    public GUIDResponse createServerAssetUse(String serverName, String userId, String capabilityGUID, String assetGUID, boolean infrastructureManagerIsHome, ServerAssetUseRequestBody requestBody) {
        String methodName = "createServerAssetUse";
        String capabilityGUIDParameterName = "capabilityGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createServerAssetUse");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createServerAssetUse");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "createServerAssetUse");
            String guid = infrastructureManagerIsHome ? handler.linkElementToElement(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), capabilityGUID, "capabilityGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, this.getServerAssetUseProperties(requestBody.getProperties(), instanceHandler.getRepositoryHelper(userId, serverName, "createServerAssetUse"), instanceHandler.getServiceName(), "createServerAssetUse"), null, null, new Date(), "createServerAssetUse") : handler.linkElementToElement(userId, null, null, capabilityGUID, "capabilityGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, false, false, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, this.getServerAssetUseProperties(requestBody.getProperties(), instanceHandler.getRepositoryHelper(userId, serverName, "createServerAssetUse"), instanceHandler.getServiceName(), "createServerAssetUse"), null, null, new Date(), "createServerAssetUse");
            response.setGUID(guid);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createServerAssetUse", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceProperties getServerAssetUseProperties(ServerAssetUseProperties properties, OMRSRepositoryHelper repositoryHelper, String serviceName, String methodName) throws InvalidParameterException {
        InstanceProperties instanceProperties = null;
        if (properties != null) {
            instanceProperties = repositoryHelper.addStringPropertyToInstance(serviceName, null, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription(), methodName);
            if (properties.getMaximumInstancesSet()) {
                instanceProperties = repositoryHelper.addIntPropertyToInstance(serviceName, null, OpenMetadataProperty.MAXIMUM_INSTANCES.name, properties.getMaximumInstances(), methodName);
            }
            if (properties.getMinimumInstancesSet()) {
                instanceProperties = repositoryHelper.addIntPropertyToInstance(serviceName, null, OpenMetadataProperty.MINIMUM_INSTANCES.name, properties.getMinimumInstances(), methodName);
            }
            if (properties.getUseType() != null) {
                try {
                    instanceProperties = repositoryHelper.addEnumPropertyToInstance(serviceName, instanceProperties, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeGUID(), ServerAssetUseType.getOpenTypeName(), properties.getUseType().getOrdinal(), methodName);
                }
                catch (TypeErrorException error) {
                    throw new InvalidParameterException((OCFCheckedExceptionBase)error, OpenMetadataProperty.USE_TYPE.name);
                }
            }
            if (properties.getEffectiveFrom() != null || properties.getEffectiveTo() != null) {
                if (instanceProperties == null) {
                    instanceProperties = new InstanceProperties();
                }
                instanceProperties.setEffectiveFromTime(properties.getEffectiveFrom());
                instanceProperties.setEffectiveToTime(properties.getEffectiveTo());
            }
        }
        return instanceProperties;
    }

    public VoidResponse updateServerAssetUse(String serverName, String userId, String serverAssetUseGUID, boolean isMergeUpdate, ServerAssetUseRequestBody requestBody) {
        String methodName = "updateServerAssetUse";
        String elementGUIDParameterName = "serverAssetUseGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateServerAssetUse");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateServerAssetUse");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "updateServerAssetUse");
            handler.updateRelationshipProperties(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), serverAssetUseGUID, "serverAssetUseGUID", OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, isMergeUpdate, this.getServerAssetUseProperties(requestBody.getProperties(), instanceHandler.getRepositoryHelper(userId, serverName, "updateServerAssetUse"), instanceHandler.getServiceName(), "updateServerAssetUse"), false, false, new Date(), "updateServerAssetUse");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateServerAssetUse", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeServerAssetUse(String serverName, String userId, String serverAssetUseGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeServerAssetUse";
        String elementGUIDParameterName = "serverAssetUseGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeServerAssetUse");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeServerAssetUse");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "removeServerAssetUse");
            handler.deleteRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), serverAssetUseGUID, "serverAssetUseGUID", OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, false, false, null, "removeServerAssetUse");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeServerAssetUse", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAssetUsesResponse getServerAssetUsesForCapability(String serverName, String userId, String capabilityGUID, int startFrom, int pageSize, UseTypeRequestBody requestBody) {
        String methodName = "getServerAssetUsesForCapability";
        String elementGUIDParameterName = "capabilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerAssetUsesForCapability");
        ServerAssetUsesResponse response = new ServerAssetUsesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServerAssetUsesForCapability");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getServerAssetUsesForCapability");
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getServerAssetUsesForCapability");
            List relationships = handler.getAttachmentLinks(userId, capabilityGUID, "capabilityGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, OpenMetadataType.ASSET.typeName, 0, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getServerAssetUsesForCapability");
            response.setElements(this.getServerAssetUseElements(userId, relationships, requestBody.getUseType(), assetHandler, handler.getRepositoryHelper(), handler.getServiceName(), serverName, "getServerAssetUsesForCapability"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getServerAssetUsesForCapability", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAssetUsesResponse getCapabilityUsesForAsset(String serverName, String userId, String assetGUID, int startFrom, int pageSize, UseTypeRequestBody requestBody) {
        String methodName = "getCapabilityUsesForAsset";
        String elementGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCapabilityUsesForAsset");
        ServerAssetUsesResponse response = new ServerAssetUsesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCapabilityUsesForAsset");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getCapabilityUsesForAsset");
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getCapabilityUsesForAsset");
            List relationships = handler.getAttachmentLinks(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, 0, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getCapabilityUsesForAsset");
            response.setElements(this.getServerAssetUseElements(userId, relationships, requestBody.getUseType(), assetHandler, handler.getRepositoryHelper(), handler.getServiceName(), serverName, "getCapabilityUsesForAsset"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCapabilityUsesForAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAssetUsesResponse getServerAssetUsesForElements(String serverName, String userId, String capabilityGUID, String assetGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String methodName = "getServerAssetUsesForElements";
        String capabilityGUIDParameterName = "capabilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerAssetUsesForElements");
        ServerAssetUsesResponse response = new ServerAssetUsesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServerAssetUsesForElements");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getServerAssetUsesForElements");
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getServerAssetUsesForElements");
            List relationships = handler.getAttachmentLinks(userId, capabilityGUID, "capabilityGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, assetGUID, OpenMetadataType.ASSET.typeName, 0, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getServerAssetUsesForElements");
            response.setElements(this.getServerAssetUseElements(userId, relationships, null, assetHandler, handler.getRepositoryHelper(), handler.getServiceName(), serverName, "getServerAssetUsesForElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getServerAssetUsesForElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerAssetUseResponse getServerAssetUseByGUID(String serverName, String userId, String guid) {
        String methodName = "getServerAssetUseByGUID";
        String elementGUIDParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerAssetUseByGUID");
        ServerAssetUseResponse response = new ServerAssetUseResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServerAssetUseByGUID");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getServerAssetUseByGUID");
            AssetHandler<AssetElement> assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getServerAssetUseByGUID");
            Relationship relationship = handler.getAttachmentLink(userId, guid, "guid", OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, "getServerAssetUseByGUID");
            if (relationship != null) {
                response.setElement(this.getServerAssetUseElement(userId, relationship, null, assetHandler, handler.getRepositoryHelper(), handler.getServiceName(), serverName, "getServerAssetUseByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getServerAssetUseByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<ServerAssetUseElement> getServerAssetUseElements(String userId, List<Relationship> relationships, ServerAssetUseType useType, AssetHandler<AssetElement> assetHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<ServerAssetUseElement> results = new ArrayList<ServerAssetUseElement>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                ServerAssetUseElement result;
                if (relationship == null || (result = this.getServerAssetUseElement(userId, relationship, useType, assetHandler, repositoryHelper, serviceName, serverName, methodName)) == null) continue;
                results.add(result);
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    private ServerAssetUseElement getServerAssetUseElement(String userId, Relationship relationship, ServerAssetUseType requestedUseType, AssetHandler<AssetElement> assetHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "relationship.entityTwoProxy.guid";
        boolean matchingUseType = false;
        InstanceProperties instanceProperties = relationship.getProperties();
        int propertyUseTypeOrdinal = repositoryHelper.removeEnumPropertyOrdinal(serviceName, OpenMetadataProperty.USE_TYPE.name, instanceProperties, methodName);
        if (requestedUseType == null) {
            matchingUseType = true;
        } else if (requestedUseType.getOrdinal() == propertyUseTypeOrdinal) {
            matchingUseType = true;
        }
        if (matchingUseType) {
            ServerAssetUseElement element = new ServerAssetUseElement();
            element.setAsset((AssetElement)assetHandler.getBeanFromRepository(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.entityTwoProxy.guid", OpenMetadataType.ASSET.typeName, false, false, new Date(), methodName));
            ElementStubConverter converter = new ElementStubConverter(repositoryHelper, serviceName, serverName);
            element.setCapabilityStub(converter.getElementStub(ElementStub.class, relationship.getEntityOneProxy(), methodName));
            if (instanceProperties != null) {
                ServerAssetUseProperties properties = new ServerAssetUseProperties();
                Iterator propertyNames = instanceProperties.getPropertyNames();
                if (propertyNames != null) {
                    while (propertyNames.hasNext()) {
                        String propertyName = (String)propertyNames.next();
                        if (OpenMetadataProperty.MAXIMUM_INSTANCES.name.equals(propertyName)) {
                            properties.setMaximumInstancesSet(true);
                            properties.setMaximumInstances(repositoryHelper.getIntProperty(serviceName, OpenMetadataProperty.MAXIMUM_INSTANCES.name, relationship.getProperties(), methodName));
                            continue;
                        }
                        if (OpenMetadataProperty.MINIMUM_INSTANCES.name.equals(propertyName)) {
                            properties.setMinimumInstancesSet(true);
                            properties.setMinimumInstances(repositoryHelper.getIntProperty(serviceName, OpenMetadataProperty.MAXIMUM_INSTANCES.name, relationship.getProperties(), methodName));
                            continue;
                        }
                        if (OpenMetadataProperty.DESCRIPTION.name.equals(propertyName)) {
                            properties.setDescription(repositoryHelper.getStringProperty(serviceName, OpenMetadataProperty.DESCRIPTION.name, relationship.getProperties(), methodName));
                            continue;
                        }
                        if (!OpenMetadataProperty.USE_TYPE.name.equals(propertyName)) continue;
                        for (ServerAssetUseType useTypeValue : ServerAssetUseType.values()) {
                            if (useTypeValue.getOrdinal() != propertyUseTypeOrdinal) continue;
                            properties.setUseType(useTypeValue);
                        }
                    }
                }
                element.setServerAssetUse(properties);
            }
            return element;
        }
        return null;
    }
}

