/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/it-infrastructure/users/{userId}"})
@Tag(name="IT Infrastructure OMAS", description="The IT Infrastructure OMAS provides APIs for tools and applications managing the IT infrastructure that supports the data assets.\n", externalDocs=@ExternalDocumentation(description="IT Infrastructure Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/it-infrastructure/"))
public class ITInfrastructureResource {
    private ITInfrastructureRESTServices restAPI = new ITInfrastructureRESTServices();

    @PostMapping(path={"/endpoints"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.createEndpoint(serverName, userId, null, requestBody);
    }

    @PostMapping(path={"/endpoints/for-infrastructure/{infrastructureGUID}"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureGUID, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.createEndpoint(serverName, userId, infrastructureGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/network-address/{networkAddress}/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String networkAddress, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, null, networkAddress, templateGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/for-infrastructure/{infrastructureGUID}/network-address/{networkAddress}/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureGUID, @PathVariable String networkAddress, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, infrastructureGUID, networkAddress, templateGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}"})
    public VoidResponse updateEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean isMergeUpdate, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.updateEndpoint(serverName, userId, endpointGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/delete"})
    public VoidResponse removeEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeEndpoint(serverName, userId, endpointGUID, requestBody);
    }

    @GetMapping(path={"/endpoints/by-search-string/{searchString}"})
    public EndpointsResponse findEndpoints(@PathVariable String serverName, @PathVariable String userId, @PathVariable String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findEndpoints(serverName, userId, searchString, startFrom, pageSize);
    }

    @GetMapping(path={"/endpoints/by-name/{name}"})
    public EndpointsResponse getEndpointsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEndpointsByName(serverName, userId, name, startFrom, pageSize);
    }

    @GetMapping(path={"/endpoints/{guid}"})
    public EndpointResponse getEndpointByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getEndpointByGUID(serverName, userId, guid);
    }
}

