/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.AssetConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ServerAssetUseListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ServerAssetUseRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ServerAssetUseResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.SoftwareCapabilityListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.SoftwareCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.SoftwareCapabilityResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UseTypeRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITInfrastructureRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/it-infrastructure/users/{userId}"})
@Tag(name="IT Infrastructure OMAS", description="The IT Infrastructure OMAS provides APIs for tools and applications managing the IT infrastructure that supports the data assets.\n", externalDocs=@ExternalDocumentation(description="IT Infrastructure Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/it-infrastructure/overview/"))
public class ITInfrastructureResource {
    private ITInfrastructureRESTServices restAPI = new ITInfrastructureRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/connections"})
    public GUIDResponse createConnection(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.createConnection(serverName, userId, requestBody);
    }

    @PostMapping(path={"/connections/from-template/{templateGUID}"})
    public GUIDResponse createConnectionFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createConnectionFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}"})
    public VoidResponse updateConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestParam boolean isMergeUpdate, @RequestBody ConnectionRequestBody requestBody) {
        return this.restAPI.updateConnection(serverName, userId, connectionGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}"})
    public VoidResponse setupConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.setupConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}/delete"})
    public VoidResponse clearConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}"})
    public VoidResponse setupEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.setupEndpoint(serverName, userId, connectionGUID, endpointGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}/delete"})
    public VoidResponse clearEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearEndpoint(serverName, userId, connectionGUID, endpointGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}"})
    public VoidResponse setupEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestBody EmbeddedConnectionRequestBody requestBody) {
        return this.restAPI.setupEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}/delete"})
    public VoidResponse clearEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, requestBody);
    }

    @PostMapping(path={"assets/{assetGUID}/connections/{connectionGUID}"})
    public VoidResponse setupAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @RequestBody AssetConnectionRequestBody requestBody) {
        return this.restAPI.setupAssetConnection(serverName, userId, assetGUID, connectionGUID, requestBody);
    }

    @PostMapping(path={"assets/{assetGUID}/connections/{connectionGUID}/delete"})
    public VoidResponse clearAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.clearAssetConnection(serverName, userId, assetGUID, connectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/delete"})
    public VoidResponse removeConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeConnection(serverName, userId, connectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/by-search-string"})
    public ConnectionsResponse findConnections(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findConnections(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/connections/by-name"})
    public ConnectionsResponse getConnectionsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConnectionsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/connections/{guid}"})
    public org.odpi.openmetadata.accessservices.itinfrastructure.rest.ConnectionResponse getConnectionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getConnectionByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/connector-types"})
    public GUIDResponse createConnectorType(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConnectorTypeRequestBody requestBody) {
        return this.restAPI.createConnectorType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/connector-types/from-template/{templateGUID}"})
    public GUIDResponse createConnectorTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createConnectorTypeFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}"})
    public VoidResponse updateConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody ConnectorTypeRequestBody requestBody) {
        return this.restAPI.updateConnectorType(serverName, userId, connectorTypeGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}/delete"})
    public VoidResponse removeConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeConnectorType(serverName, userId, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connector-types/by-search-string"})
    public ConnectorTypesResponse findConnectorTypes(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findConnectorTypes(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/connector-types/by-name"})
    public ConnectorTypesResponse getConnectorTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConnectorTypesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/connector-types/{guid}"})
    public ConnectorTypeResponse getConnectorTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getConnectorTypeByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/endpoints"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.createEndpoint(serverName, userId, null, requestBody);
    }

    @PostMapping(path={"/endpoints/for-infrastructure/{infrastructureGUID}"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureGUID, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.createEndpoint(serverName, userId, infrastructureGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/network-address/{networkAddress}/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String networkAddress, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, null, networkAddress, templateGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/for-infrastructure/{infrastructureGUID}/network-address/{networkAddress}/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureGUID, @PathVariable String networkAddress, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, infrastructureGUID, networkAddress, templateGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}"})
    public VoidResponse updateEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean isMergeUpdate, @RequestBody EndpointRequestBody requestBody) {
        return this.restAPI.updateEndpoint(serverName, userId, endpointGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/delete"})
    public VoidResponse removeEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeEndpoint(serverName, userId, endpointGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/by-search-string"})
    public EndpointsResponse findEndpoints(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findEndpoints(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/endpoints/by-name"})
    public EndpointsResponse getEndpointsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEndpointsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/endpoints/by-network-address"})
    public EndpointsResponse getEndpointsByNetworkAddress(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        return this.restAPI.getEndpointsByNetworkAddress(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/endpoints/for-infrastructure/{infrastructureGUID}"})
    public EndpointsResponse getEndpointsForInfrastructure(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEndpointsForInfrastructure(serverName, userId, infrastructureGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/endpoints/{guid}"})
    public EndpointResponse getEndpointByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getEndpointByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/software-capabilities"})
    public GUIDResponse createSoftwareCapability(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean infrastructureManagerIsHome, @RequestBody SoftwareCapabilityRequestBody requestBody) {
        return this.restAPI.createSoftwareCapability(serverName, userId, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/software-capabilities/from-template/{templateGUID}"})
    public GUIDResponse createSoftwareCapabilityFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createSoftwareCapabilityFromTemplate(serverName, userId, templateGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/software-capabilities/{capabilityGUID}"})
    public VoidResponse updateSoftwareCapability(@PathVariable String serverName, @PathVariable String userId, @PathVariable String capabilityGUID, @RequestParam boolean isMergeUpdate, @RequestBody SoftwareCapabilityRequestBody requestBody) {
        return this.restAPI.updateSoftwareCapability(serverName, userId, capabilityGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/software-capabilities/{capabilityGUID}/delete"})
    public VoidResponse removeSoftwareCapability(@PathVariable String serverName, @PathVariable String userId, @PathVariable String capabilityGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeSoftwareCapability(serverName, userId, capabilityGUID, requestBody);
    }

    @PostMapping(path={"/software-capabilities/by-search-string"})
    public SoftwareCapabilityListResponse findSoftwareCapabilities(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSoftwareCapabilities(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/software-capabilities/by-name"})
    public SoftwareCapabilityListResponse getSoftwareCapabilitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getSoftwareCapabilitiesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/software-capabilities/{guid}"})
    public SoftwareCapabilityResponse getSoftwareCapabilityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSoftwareCapabilityByGUID(serverName, userId, guid);
    }

    @PostMapping(path={"/server-asset-uses/software-capabilities/{capabilityGUID}/assets/{assetGUID}"})
    public GUIDResponse createServerAssetUse(@PathVariable String serverName, @PathVariable String userId, @PathVariable String capabilityGUID, @PathVariable String assetGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody ServerAssetUseRequestBody requestBody) {
        return this.restAPI.createServerAssetUse(serverName, userId, capabilityGUID, assetGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/server-asset-uses/{serverAssetUseGUID}"})
    public VoidResponse updateServerAssetUse(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serverAssetUseGUID, @RequestParam boolean isMergeUpdate, @RequestBody ServerAssetUseRequestBody requestBody) {
        return this.restAPI.updateServerAssetUse(serverName, userId, serverAssetUseGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/server-asset-uses/{serverAssetUseGUID}/delete"})
    public VoidResponse removeServerAssetUse(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serverAssetUseGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeServerAssetUse(serverName, userId, serverAssetUseGUID, requestBody);
    }

    @PostMapping(path={"/server-asset-uses/software-capabilities/{capabilityGUID}"})
    public ServerAssetUseListResponse getServerAssetUsesForCapability(@PathVariable String serverName, @PathVariable String userId, @PathVariable String capabilityGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody UseTypeRequestBody requestBody) {
        return this.restAPI.getServerAssetUsesForCapability(serverName, userId, capabilityGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/server-asset-uses/assets/{assetGUID}"})
    public ServerAssetUseListResponse getCapabilityUsesForAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody UseTypeRequestBody requestBody) {
        return this.restAPI.getCapabilityUsesForAsset(serverName, userId, assetGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/server-asset-uses/software-capabilities/{capabilityGUID}/assets/{assetGUID}/by-elements"})
    public ServerAssetUseListResponse getServerAssetUsesForElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String capabilityGUID, @PathVariable String assetGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getServerAssetUsesForElements(serverName, userId, capabilityGUID, assetGUID, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/server-asset-uses/{guid}"})
    public ServerAssetUseResponse getServerAssetUseByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getServerAssetUseByGUID(serverName, userId, guid);
    }
}

