/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.ITProfileResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.UserIdentityResponse;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITProfileRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/it-infrastructure/users/{userId}"})
@Tag(name="IT Infrastructure OMAS", description="The IT Infrastructure OMAS provides APIs for tools and applications managing the IT infrastructure that supports the data assets.\n", externalDocs=@ExternalDocumentation(description="IT Infrastructure Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/it-infrastructure/overview/"))
public class ITProfileResource {
    private ITProfileRESTServices restAPI = new ITProfileRESTServices();

    @PostMapping(path={"/profiles"})
    public GUIDResponse createITProfile(@PathVariable String serverName, @PathVariable String userId, @RequestBody ITProfileRequestBody requestBody) {
        return this.restAPI.createITProfile(serverName, userId, requestBody);
    }

    @PostMapping(path={"/profiles/{itProfileGUID}"})
    public VoidResponse updateITProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String itProfileGUID, @RequestParam boolean isMergeUpdate, @RequestBody ITProfileRequestBody requestBody) {
        return this.restAPI.updateITProfile(serverName, userId, itProfileGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/profiles/{itProfileGUID}/delete"})
    public VoidResponse deleteITProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String itProfileGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteITProfile(serverName, userId, itProfileGUID, requestBody);
    }

    @PostMapping(path={"/profiles/{itProfileGUID}/contact-methods"})
    public GUIDResponse addContactMethod(@PathVariable String serverName, @PathVariable String userId, @PathVariable String itProfileGUID, @RequestBody ContactMethodRequestBody requestBody) {
        return this.restAPI.addContactMethod(serverName, userId, itProfileGUID, requestBody);
    }

    @PostMapping(path={"/profiles/contact-methods/{contactMethodGUID}/delete"})
    public VoidResponse deleteContactMethod(@PathVariable String serverName, @PathVariable String userId, @PathVariable String contactMethodGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteContactMethod(serverName, userId, contactMethodGUID, requestBody);
    }

    @GetMapping(path={"/profiles/{itProfileGUID}"})
    public ITProfileResponse getITProfileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String itProfileGUID) {
        return this.restAPI.getITProfileByGUID(serverName, userId, itProfileGUID);
    }

    @GetMapping(path={"/profiles/user-ids/{itProfileUserId}"})
    public ITProfileResponse getITProfileByUserId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String itProfileUserId) {
        return this.restAPI.getITProfileByUserId(serverName, userId, itProfileUserId);
    }

    @PostMapping(path={"/profiles/by-name"})
    public ITProfileListResponse getITProfileByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getITProfileByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/profiles/by-search-string"})
    public ITProfileListResponse findITProfile(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findITProfile(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/user-identities"})
    public GUIDResponse createUserIdentity(@PathVariable String serverName, @PathVariable String userId, @RequestBody UserIdentityRequestBody requestBody) {
        return this.restAPI.createUserIdentity(serverName, userId, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}"})
    public VoidResponse updateUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestParam boolean isMergeUpdate, @RequestBody UserIdentityRequestBody requestBody) {
        return this.restAPI.updateUserIdentity(serverName, userId, userIdentityGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/delete"})
    public VoidResponse deleteUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteUserIdentity(serverName, userId, userIdentityGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/personal-profiles/{profileGUID}/link"})
    public VoidResponse addIdentityToProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.addIdentityToProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/unlink"})
    public VoidResponse removeIdentityFromProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeIdentityFromProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/by-search-string"})
    public UserIdentityListResponse findUserIdentities(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findUserIdentities(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/user-identities/by-name"})
    public UserIdentityListResponse getUserIdentitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getUserIdentitiesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/user-identities/{userIdentityGUID}"})
    public UserIdentityResponse getUserIdentityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID) {
        return this.restAPI.getUserIdentityByGUID(serverName, userId, userIdentityGUID);
    }
}

