/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.itinfrastructure.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.itinfrastructure.server.ITAssetRESTService;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetExtensionsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetRelationshipsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/it-infrastructure/users/{userId}"})
@Tag(name="Metadata Access Server: IT Infrastructure OMAS", description="The IT Infrastructure OMAS provides APIs for tools and applications managing the IT infrastructure that supports the data assets.\n", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/it-infrastructure/overview/"))
public class ITAssetResource {
    private static final ITAssetRESTService restAPI = new ITAssetRESTService();

    @PostMapping(path={"/assets"})
    public GUIDResponse createAsset(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean infrastructureManagerIsHome, @RequestBody AssetRequestBody requestBody) {
        return restAPI.createAsset(serverName, userId, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/assets/from-template/{templateGUID}"})
    public GUIDResponse createAssetFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return restAPI.createAssetFromTemplate(serverName, userId, templateGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}"})
    public VoidResponse updateAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam boolean isMergeUpdate, @RequestBody AssetRequestBody requestBody) {
        return restAPI.updateAsset(serverName, userId, assetGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/status"})
    public VoidResponse updateAssetStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @RequestBody ElementStatusRequestBody requestBody) {
        return restAPI.updateAssetStatus(serverName, userId, assetTypeName, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/{relationshipTypeName}/{relatedAssetTypeName}/{relatedAssetGUID}"})
    public VoidResponse setupRelatedAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String relationshipTypeName, @PathVariable String relatedAssetTypeName, @PathVariable String relatedAssetGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody AssetExtensionsRequestBody requestBody) {
        return restAPI.setupRelatedAsset(serverName, userId, assetTypeName, assetGUID, relationshipTypeName, relatedAssetTypeName, relatedAssetGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/assets/relationships/{relationshipTypeName}/{relationshipGUID}/update"})
    public VoidResponse updateAssetRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipTypeName, @PathVariable String relationshipGUID, @RequestParam boolean isMergeUpdate, @RequestBody AssetExtensionsRequestBody requestBody) {
        return restAPI.updateAssetRelationship(serverName, userId, relationshipTypeName, relationshipGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/{relationshipTypeName}/{relatedAssetTypeName}/{relatedAssetGUID}/delete"})
    public VoidResponse clearRelatedAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String relationshipTypeName, @PathVariable String relatedAssetTypeName, @PathVariable String relatedAssetGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearRelatedAsset(serverName, userId, assetTypeName, assetGUID, relationshipTypeName, relatedAssetTypeName, relatedAssetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/classify/{classificationName}"})
    public VoidResponse addClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String classificationName, @RequestParam boolean infrastructureManagerIsHome, @RequestBody AssetExtensionsRequestBody requestBody) {
        return restAPI.addClassification(serverName, userId, assetTypeName, assetGUID, classificationName, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/reclassify/{classificationName}"})
    public VoidResponse updateClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String classificationName, @RequestParam boolean isMergeUpdate, @RequestBody AssetExtensionsRequestBody requestBody) {
        return restAPI.updateClassification(serverName, userId, assetTypeName, assetGUID, classificationName, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/declassify/{classificationName}"})
    public VoidResponse clearClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String classificationName, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearClassification(serverName, userId, assetTypeName, assetGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/publish"})
    public VoidResponse publishAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return restAPI.publishAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/withdraw"})
    public VoidResponse withdrawAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return restAPI.withdrawAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/delete"})
    public VoidResponse removeAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return restAPI.removeAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/by-search-string"})
    public AssetElementsResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return restAPI.findAssets(serverName, userId, assetTypeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/by-name"})
    public AssetElementsResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return restAPI.getAssetsByName(serverName, userId, assetTypeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/by-deployed-implementation-type"})
    public AssetElementsResponse getAssetsByDeployedImplementationType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) NameRequestBody requestBody) {
        return restAPI.getAssetsByDeployedImplementationType(serverName, userId, assetTypeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/infrastructure-managers/{infrastructureManagerGUID}/{infrastructureManagerName}/assets/{assetTypeName}"})
    public AssetElementsResponse getAssetsForInfrastructureManager(@PathVariable String serverName, @PathVariable String userId, @PathVariable String infrastructureManagerGUID, @PathVariable String infrastructureManagerName, @PathVariable String assetTypeName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getAssetsForInfrastructureManager(serverName, userId, infrastructureManagerGUID, infrastructureManagerName, assetTypeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}"})
    public AssetElementResponse getAssetByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getAssetByGUID(serverName, userId, assetTypeName, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/{relationshipTypeName}/{relatedAssetTypeName}/relationships"})
    public AssetRelationshipsResponse getAssetRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String relationshipTypeName, @PathVariable String relatedAssetTypeName, @RequestParam int startingEnd, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getAssetRelationships(serverName, userId, assetTypeName, assetGUID, relationshipTypeName, relatedAssetTypeName, startingEnd, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/{assetTypeName}/{assetGUID}/{relationshipTypeName}/{relatedAssetTypeName}"})
    public RelatedAssetsResponse getRelatedAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetTypeName, @PathVariable String assetGUID, @PathVariable String relationshipTypeName, @PathVariable String relatedAssetTypeName, @RequestParam int startingEnd, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getRelatedAssets(serverName, userId, assetTypeName, assetGUID, relationshipTypeName, relatedAssetTypeName, startingEnd, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}"})
    public GUIDResponse setupDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody DataFlowRequestBody requestBody) {
        return restAPI.setupDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}/retrieve"})
    public DataFlowElementResponse getDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestBody NameRequestBody requestBody) {
        return restAPI.getDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/update"})
    public VoidResponse updateDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestBody DataFlowRequestBody requestBody) {
        return restAPI.updateDataFlow(serverName, userId, dataFlowGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/remove"})
    public VoidResponse clearDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearDataFlow(serverName, userId, dataFlowGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/retrieve"})
    public DataFlowElementsResponse getDataFlowConsumers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getDataFlowConsumers(serverName, userId, dataSupplierGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-flows/consumers/{dataConsumerGUID}/suppliers/retrieve"})
    public DataFlowElementsResponse getDataFlowSuppliers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataConsumerGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getDataFlowSuppliers(serverName, userId, dataConsumerGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}"})
    public GUIDResponse setupControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody ControlFlowRequestBody requestBody) {
        return restAPI.setupControlFlow(serverName, userId, currentStepGUID, nextStepGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}/retrieve"})
    public ControlFlowElementResponse getControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestBody NameRequestBody requestBody) {
        return restAPI.getControlFlow(serverName, userId, currentStepGUID, nextStepGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/update"})
    public VoidResponse updateControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestBody ControlFlowRequestBody requestBody) {
        return restAPI.updateControlFlow(serverName, userId, controlFlowGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/remove"})
    public VoidResponse clearControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearControlFlow(serverName, userId, controlFlowGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowNextSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getControlFlowNextSteps(serverName, userId, currentStepGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/previous-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowPreviousSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getControlFlowPreviousSteps(serverName, userId, currentStepGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}"})
    public GUIDResponse setupProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestParam boolean infrastructureManagerIsHome, @RequestBody ProcessCallRequestBody requestBody) {
        return restAPI.setupProcessCall(serverName, userId, callerGUID, calledGUID, infrastructureManagerIsHome, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}/retrieve"})
    public ProcessCallElementResponse getProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestBody NameRequestBody requestBody) {
        return restAPI.getProcessCall(serverName, userId, callerGUID, calledGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/update"})
    public VoidResponse updateProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestBody ProcessCallRequestBody requestBody) {
        return restAPI.updateProcessCall(serverName, userId, processCallGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/remove"})
    public VoidResponse clearProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearProcessCall(serverName, userId, processCallGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/retrieve"})
    public ProcessCallElementsResponse getProcessCalled(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getProcessCalled(serverName, userId, callerGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/process-calls/called/{calledGUID}/callers/retrieve"})
    public ProcessCallElementsResponse getProcessCallers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String calledGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getProcessCallers(serverName, userId, calledGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}"})
    public VoidResponse setupLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestBody LineageMappingRequestBody requestBody) {
        return restAPI.setupLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}/retrieve"})
    public LineageMappingElementResponse getLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestBody NameRequestBody requestBody) {
        return restAPI.getLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/{lineageMappingGUID}/remove"})
    public VoidResponse clearLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String lineageMappingGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return restAPI.clearLineageMapping(serverName, userId, lineageMappingGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/retrieve"})
    public LineageMappingElementsResponse getDestinationLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getDestinationLineageMappings(serverName, userId, sourceElementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/destinations/{destinationElementGUID}/sources/retrieve"})
    public LineageMappingElementsResponse getSourceLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String destinationElementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody ResultsRequestBody requestBody) {
        return restAPI.getSourceLineageMappings(serverName, userId, destinationElementGUID, startFrom, pageSize, requestBody);
    }
}

