/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ITInfrastructureEventInterface;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ITInfrastructureEventListener;
import org.odpi.openmetadata.accessservices.itinfrastructure.events.ITInfrastructureOutTopicEvent;
import org.odpi.openmetadata.accessservices.itinfrastructure.ffdc.ITInfrastructureErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITInfrastructureOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements ITInfrastructureEventInterface {
    private static final Logger log = LoggerFactory.getLogger(ITInfrastructureOutTopicClientConnector.class);
    private final List<ITInfrastructureEventListener> internalEventListeners = new ArrayList<ITInfrastructureEventListener>();

    public synchronized void registerListener(String userId, ITInfrastructureEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(ITInfrastructureErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                ITInfrastructureOutTopicEvent eventObject = (ITInfrastructureOutTopicEvent)super.getEventBean(event, ITInfrastructureOutTopicEvent.class);
                for (ITInfrastructureEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

