/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X2) {
        int m = X2.length;
        if (m <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X2);
        double s2 = 0.0;
        for (int i = 0; i < m; ++i) {
            s2 += ((double)X2[i] - xbar) * ((double)X2[i] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m - 1));
    }

    public static double avg(int[] X2) {
        double xbar = 0.0;
        int m = X2.length;
        if (m == 0) {
            return 0.0;
        }
        for (int i = 0; i < m; ++i) {
            xbar += (double)X2[i];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(int[] X2) {
        int min = Integer.MAX_VALUE;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            if (X2[i] >= min) continue;
            min = X2[i];
        }
        return min;
    }

    public static int max(int[] X2) {
        int max = Integer.MIN_VALUE;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            if (X2[i] <= max) continue;
            max = X2[i];
        }
        return max;
    }

    public static int sum(int[] X2) {
        int s = 0;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i = 0; i < m; ++i) {
            s += X2[i];
        }
        return s;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

