/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.ant.MapperAdapter;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.util.filter.Filter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileNameMapper;

public class IvyRetrieve
extends IvyPostResolveTask {
    private static final Collection OVERWRITEMODE_VALUES = Arrays.asList("always", "never", "newer", "different");
    private String pattern;
    private String ivypattern = null;
    private boolean sync = false;
    private boolean symlink = false;
    private String overwriteMode = "newer";
    private String pathId = null;
    private String setId = null;
    private Mapper mapper = null;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String setId) {
        this.setId = setId;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (!this.getAllowedLogOptions().contains(this.getLog())) {
            throw new BuildException("invalid option for 'log': " + this.getLog() + ". Available options are " + this.getAllowedLogOptions());
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            Iterator iter2;
            Filter artifactFilter = this.getArtifactFilter();
            RetrieveReport report = this.getIvyInstance().retrieve(this.getResolvedMrid(), ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(this.splitConfs(this.getConf())).setDestArtifactPattern(this.pattern).setDestIvyPattern(this.ivypattern).setArtifactFilter(artifactFilter).setSync(this.sync).setOverwriteMode(this.getOverwriteMode()).setUseOrigin(this.isUseOrigin()).setMakeSymlinks(this.symlink).setResolveId(this.getResolveId()).setMapper(this.mapper == null ? null : new MapperAdapter(this.mapper)));
            int targetsCopied = report.getNbrArtifactsCopied();
            boolean haveTargetsBeenCopied = targetsCopied > 0;
            this.getProject().setProperty("ivy.nb.targets.copied", String.valueOf(targetsCopied));
            this.getProject().setProperty("ivy.targets.copied", String.valueOf(haveTargetsBeenCopied));
            if (this.getPathId() != null) {
                Path path = new Path(this.getProject());
                this.getProject().addReference(this.getPathId(), (Object)path);
                iter2 = report.getRetrievedFiles().iterator();
                while (iter2.hasNext()) {
                    path.createPathElement().setLocation((File)iter2.next());
                }
            }
            if (this.getSetId() != null) {
                FileSet fileset = new FileSet();
                fileset.setProject(this.getProject());
                this.getProject().addReference(this.getSetId(), (Object)fileset);
                fileset.setDir(report.getRetrieveRoot());
                iter2 = report.getRetrievedFiles().iterator();
                while (iter2.hasNext()) {
                    PatternSet.NameEntry ne = fileset.createInclude();
                    ne.setName(this.getPath(report.getRetrieveRoot(), (File)iter2.next()));
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to ivy retrieve: " + ex, (Throwable)ex);
        }
    }

    protected Collection getAllowedLogOptions() {
        return Arrays.asList("default", "download-only", "quiet");
    }

    public String getIvypattern() {
        return this.ivypattern;
    }

    public void setIvypattern(String ivypattern) {
        this.ivypattern = ivypattern;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public void setOverwriteMode(String overwriteMode) {
        if (!OVERWRITEMODE_VALUES.contains(overwriteMode)) {
            throw new IllegalArgumentException("invalid overwriteMode value '" + overwriteMode + "'. " + "Valid values are " + OVERWRITEMODE_VALUES);
        }
        this.overwriteMode = overwriteMode;
    }

    public String getOverwriteMode() {
        return this.overwriteMode;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new IllegalArgumentException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        Mapper m = new Mapper(this.getProject());
        m.add(fileNameMapper);
        this.addMapper(m);
    }

    private String getPath(File base, File file) {
        String absoluteBasePath = base.getAbsolutePath();
        int beginIndex = absoluteBasePath.length();
        if (!absoluteBasePath.endsWith(File.separator)) {
            ++beginIndex;
        }
        return file.getAbsolutePath().substring(beginIndex);
    }
}

