/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.lang.Tuple;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.jsr223.CompilationOptionsCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.CompileStaticGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ConfigurationGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyClassLoader;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslator;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ImportGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.InterpreterModeGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ManagedConcurrentValueMap;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TypeCheckedGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.loaders.GremlinLoader;
import org.apache.tinkerpop.gremlin.jsr223.ConcurrentBindings;
import org.apache.tinkerpop.gremlin.jsr223.CoreGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptContext;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.ImportCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.TranslatorCustomizer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.util.ReferenceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinGroovyScriptEngine
extends GroovyScriptEngineImpl
implements GremlinScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(GremlinGroovyScriptEngine.class);
    public static final String COMPILE_OPTIONS_VAR_TYPES = "sandbox.bindings";
    public static final String KEY_REFERENCE_TYPE = "#jsr223.groovy.engine.keep.globals";
    public static final String REFERENCE_TYPE_PHANTOM = "phantom";
    public static final String REFERENCE_TYPE_WEAK = "weak";
    public static final String REFERENCE_TYPE_SOFT = "soft";
    public static final String REFERENCE_TYPE_HARD = "hard";
    public static final String COLLECTED_BOUND_VARS_MAP_VARNAME = "gremlin_script_engine_collected_boundvars";
    private static final Pattern patternImportStatic = Pattern.compile("\\Aimport\\sstatic.*");
    public static final ThreadLocal<Map<String, Object>> COMPILE_OPTIONS = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private GremlinGroovyClassLoader loader;
    private final LoadingCache<String, Future<Class>> classMap;
    private final ManagedConcurrentValueMap<String, Closure> globalClosures = new ManagedConcurrentValueMap(ReferenceBundle.getHardBundle());
    private static final AtomicLong scriptNameCounter = new AtomicLong(0L);
    private final AtomicLong longRunCompilationCount = new AtomicLong(0L);
    private final AtomicLong failedCompilationCount = new AtomicLong(0L);
    private final Set<String> loadedPlugins = new HashSet<String>();
    private volatile GremlinGroovyScriptEngineFactory factory;
    private static final String STATIC = "static";
    private static final String SCRIPT = "Script";
    private static final String DOT_GROOVY = ".groovy";
    private static final String GROOVY_LANG_SCRIPT = "groovy.lang.Script";
    private final ImportGroovyCustomizer importGroovyCustomizer;
    private final List<GroovyCustomizer> groovyCustomizers;
    private final boolean globalFunctionCacheEnabled;
    private final boolean interpreterModeEnabled;
    private final long expectedCompilationTime;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;
    private final boolean typeCheckingEnabled;

    public GremlinGroovyScriptEngine() {
        this(new Customizer[0]);
    }

    public GremlinGroovyScriptEngine(Customizer ... customizers) {
        this.setBindings(new ConcurrentBindings(), 200);
        ArrayList<Customizer> listOfCustomizers = new ArrayList<Customizer>(Arrays.asList(customizers));
        CoreGremlinPlugin.instance().getCustomizers("gremlin-groovy").ifPresent(c -> listOfCustomizers.addAll(Arrays.asList(c)));
        GremlinLoader.load();
        List<ImportCustomizer> importCustomizers = listOfCustomizers.stream().filter(p -> p instanceof ImportCustomizer).map(p -> (ImportCustomizer)p).collect(Collectors.toList());
        ImportCustomizer[] importCustomizerArray = new ImportCustomizer[importCustomizers.size()];
        this.importGroovyCustomizer = new ImportGroovyCustomizer(importCustomizers.toArray(importCustomizerArray));
        this.groovyCustomizers = listOfCustomizers.stream().filter(p -> p instanceof GroovyCustomizer).map(p -> (GroovyCustomizer)p).collect(Collectors.toList());
        Optional<CompilationOptionsCustomizer> compilationOptionsCustomizerProvider = listOfCustomizers.stream().filter(p -> p instanceof CompilationOptionsCustomizer).map(p -> (CompilationOptionsCustomizer)p).findFirst();
        this.expectedCompilationTime = compilationOptionsCustomizerProvider.map(CompilationOptionsCustomizer::getExpectedCompilationTime).orElse(5000L);
        this.globalFunctionCacheEnabled = compilationOptionsCustomizerProvider.map(CompilationOptionsCustomizer::isGlobalFunctionCacheEnabled).orElse(true);
        this.classMap = Caffeine.from(compilationOptionsCustomizerProvider.map(CompilationOptionsCustomizer::getClassMapCacheSpecification).orElse("softValues")).recordStats().build(new GroovyCacheLoader());
        this.typeCheckingEnabled = listOfCustomizers.stream().anyMatch(p -> p instanceof TypeCheckedGroovyCustomizer || p instanceof CompileStaticGroovyCustomizer);
        this.interpreterModeEnabled = this.groovyCustomizers.stream().anyMatch(p -> p.getClass().equals(InterpreterModeGroovyCustomizer.class));
        Optional<TranslatorCustomizer> translatorCustomizer = listOfCustomizers.stream().filter(p -> p instanceof TranslatorCustomizer).map(p -> (TranslatorCustomizer)p).findFirst();
        this.typeTranslator = translatorCustomizer.map(TranslatorCustomizer::createTypeTranslator).orElseGet(GroovyTranslator.DefaultTypeTranslator::new);
        this.createClassLoader();
    }

    public Set getPlugins() {
        return this.loadedPlugins;
    }

    @Override
    public Traversal.Admin eval(Bytecode bytecode, Bindings bindings, String traversalSource) throws ScriptException {
        if (traversalSource.equals("gremlinscriptengine__g")) {
            throw new IllegalArgumentException("The traversalSource cannot have the name gremlinscriptengine__g - it is reserved");
        }
        if (bindings.containsKey("gremlinscriptengine__g")) {
            throw new IllegalArgumentException("Bindings cannot include gremlinscriptengine__g - it is reserved");
        }
        if (!bindings.containsKey(traversalSource)) {
            throw new IllegalArgumentException("The bindings available to the ScriptEngine do not contain a traversalSource named: " + traversalSource);
        }
        Object b = bindings.get(traversalSource);
        if (!(b instanceof TraversalSource)) {
            throw new IllegalArgumentException(traversalSource + " is of type " + b.getClass().getSimpleName() + " and is not an instance of TraversalSource");
        }
        SimpleBindings inner = new SimpleBindings();
        inner.putAll(bindings);
        inner.putAll((Map<? extends String, ? extends Object>)bytecode.getBindings());
        inner.put("gremlinscriptengine__g", b);
        return (Traversal.Admin)this.eval(GroovyTranslator.of("gremlinscriptengine__g", this.typeTranslator).translate(bytecode), (Bindings)inner);
    }

    public void reset() {
        this.internalReset();
        this.getContext().getBindings(100).clear();
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        GremlinScriptContext ctxt = new GremlinScriptContext(this.context.getReader(), this.context.getWriter(), this.context.getErrorWriter());
        Bindings gs = this.getBindings(200);
        if (gs != null) {
            ctxt.setBindings(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        ctxt.setBindings(nn, 100);
        return ctxt;
    }

    private void internalReset() {
        this.createClassLoader();
        this.classMap.invalidateAll();
        this.globalClosures.clear();
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (this.globalFunctionCacheEnabled) {
            try {
                String val = (String)context.getAttribute(KEY_REFERENCE_TYPE, 100);
                ReferenceBundle bundle = ReferenceBundle.getHardBundle();
                if (val != null && val.length() > 0) {
                    if (val.equalsIgnoreCase(REFERENCE_TYPE_SOFT)) {
                        bundle = ReferenceBundle.getSoftBundle();
                    } else if (val.equalsIgnoreCase(REFERENCE_TYPE_WEAK)) {
                        bundle = ReferenceBundle.getWeakBundle();
                    } else if (val.equalsIgnoreCase(REFERENCE_TYPE_PHANTOM)) {
                        bundle = ReferenceBundle.getPhantomBundle();
                    }
                }
                this.globalClosures.setBundle(bundle);
            }
            catch (ClassCastException val) {
                // empty catch block
            }
        }
        try {
            this.registerBindingTypes(context);
            Class clazz = this.getScriptClass(script);
            if (null == clazz) {
                throw new ScriptException("Script class is null");
            }
            return this.eval(clazz, context);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GremlinScriptEngineFactory getFactory() {
        if (this.factory == null) {
            GremlinGroovyScriptEngine gremlinGroovyScriptEngine = this;
            synchronized (gremlinGroovyScriptEngine) {
                if (this.factory == null) {
                    this.factory = new GremlinGroovyScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public CompiledScript compile(String scriptSource) throws ScriptException {
        try {
            return new GroovyCompiledScript(this, this.getScriptClass(scriptSource));
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("Script object can not be null");
        }
        return this.invokeImpl(thiz, name, args);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clazz) {
        if (null == thiz) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(thiz, clazz);
    }

    public long getClassCacheLongRunCompilationCount() {
        return this.longRunCompilationCount.longValue();
    }

    public long getClassCacheEstimatedSize() {
        return this.classMap.estimatedSize();
    }

    public double getClassCacheAverageLoadPenalty() {
        return this.classMap.stats().averageLoadPenalty();
    }

    public long getClassCacheEvictionCount() {
        return this.classMap.stats().evictionCount();
    }

    public long getClassCacheEvictionWeight() {
        return this.classMap.stats().evictionWeight();
    }

    public long getClassCacheHitCount() {
        return this.classMap.stats().hitCount();
    }

    public double getClassCacheHitRate() {
        return this.classMap.stats().hitRate();
    }

    public long getClassCacheLoadCount() {
        return this.classMap.stats().loadCount();
    }

    public long getClassCacheLoadFailureCount() {
        return this.failedCompilationCount.longValue();
    }

    public double getClassCacheLoadFailureRate() {
        long totalLoadCount = this.classMap.stats().loadCount();
        return totalLoadCount == 0L ? 0.0 : (double)this.failedCompilationCount.longValue() / (double)totalLoadCount;
    }

    public long getClassCacheLoadSuccessCount() {
        return this.classMap.stats().loadCount() - this.failedCompilationCount.longValue();
    }

    public long getClassCacheMissCount() {
        return this.classMap.stats().missCount();
    }

    public double getClassCacheMissRate() {
        return this.classMap.stats().missRate();
    }

    public long getClassCacheRequestCount() {
        return this.classMap.stats().missCount();
    }

    public long getClassCacheTotalLoadTime() {
        return this.classMap.stats().totalLoadTime();
    }

    Class getScriptClass(String script) throws Exception {
        try {
            return this.classMap.get(script).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof CompilationFailedException) {
                throw (CompilationFailedException)t;
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    boolean isCached(String script) {
        return this.classMap.getIfPresent(script) != null;
    }

    Object eval(Class scriptClass, final ScriptContext context) throws ScriptException {
        Binding binding = new Binding(context.getBindings(100)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getVariable(String name) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    Writer writer;
                    int scope = context.getAttributesScope(name);
                    if (scope != -1) {
                        return context.getAttribute(name, scope);
                    }
                    if ("out".equals(name) && (writer = context.getWriter()) != null) {
                        return writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
                    }
                    if ("context".equals(name)) {
                        return context;
                    }
                }
                throw new MissingPropertyException(name, this.getClass());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVariable(String name, Object value) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    context.setAttribute(name, value, scope);
                }
            }
        };
        try {
            Map localVars;
            if (!Script.class.isAssignableFrom(scriptClass)) {
                return scriptClass;
            }
            Script scriptObject = InvokerHelper.createScript(scriptClass, binding);
            if (this.globalFunctionCacheEnabled) {
                for (Method m : scriptClass.getMethods()) {
                    String name = m.getName();
                    this.globalClosures.put(name, new MethodClosure((Object)scriptObject, name));
                }
            }
            MetaClass oldMetaClass = scriptObject.getMetaClass();
            scriptObject.setMetaClass(new DelegatingMetaClass(oldMetaClass){

                @Override
                public Object invokeMethod(Object object, String name, Object args) {
                    if (args == null) {
                        return this.invokeMethod(object, name, MetaClassHelper.EMPTY_ARRAY);
                    }
                    if (args instanceof Tuple) {
                        return this.invokeMethod(object, name, ((Tuple)args).toArray());
                    }
                    if (args instanceof Object[]) {
                        return this.invokeMethod(object, name, (Object[])args);
                    }
                    return this.invokeMethod(object, name, new Object[]{args});
                }

                @Override
                public Object invokeMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }

                @Override
                public Object invokeStaticMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeStaticMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }
            });
            Object o = scriptObject.run();
            if (this.interpreterModeEnabled && (localVars = (Map)context.getAttribute(COLLECTED_BOUND_VARS_MAP_VARNAME)) != null) {
                localVars.entrySet().forEach(e -> {
                    if (this.globalFunctionCacheEnabled && e.getValue() instanceof Closure) {
                        this.globalClosures.put((String)e.getKey(), (Closure)e.getValue());
                    }
                    context.setAttribute((String)e.getKey(), e.getValue(), 100);
                });
                context.removeAttribute(COLLECTED_BOUND_VARS_MAP_VARNAME, 100);
                localVars.clear();
            }
            return o;
        }
        catch (Exception e2) {
            throw new ScriptException(e2);
        }
    }

    private void registerBindingTypes(ScriptContext context) {
        if (this.typeCheckingEnabled) {
            HashMap variableTypes = new HashMap();
            GremlinGroovyScriptEngine.clearVarTypes();
            context.getBindings(200).forEach((k, v) -> {
                ClassNode cfr_ignored_0 = variableTypes.put(k, null == v ? null : ClassHelper.make(v.getClass()));
            });
            context.getBindings(100).forEach((k, v) -> {
                ClassNode cfr_ignored_0 = variableTypes.put(k, null == v ? null : ClassHelper.make(v.getClass()));
            });
            COMPILE_OPTIONS.get().put(COMPILE_OPTIONS_VAR_TYPES, variableTypes);
        }
    }

    private static void clearVarTypes() {
        Map<String, Object> m = COMPILE_OPTIONS.get();
        if (m.containsKey(COMPILE_OPTIONS_VAR_TYPES)) {
            ((Map)m.get(COMPILE_OPTIONS_VAR_TYPES)).clear();
        }
    }

    private Object invokeImpl(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("Method name can not be null");
        }
        try {
            if (thiz != null) {
                return InvokerHelper.invokeMethod(thiz, name, args);
            }
        }
        catch (MissingMethodException mme) {
            throw new NoSuchMethodException(mme.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.callGlobal(name, args);
    }

    private synchronized void createClassLoader() {
        CompilerConfiguration conf = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        conf.addCompilationCustomizers(this.importGroovyCustomizer.create());
        this.groovyCustomizers.stream().filter(cp -> !(cp instanceof ConfigurationGroovyCustomizer)).forEach(p -> conf.addCompilationCustomizers(p.create()));
        this.groovyCustomizers.stream().filter(cp -> cp instanceof ConfigurationGroovyCustomizer).findFirst().ifPresent(cp -> ((ConfigurationGroovyCustomizer)cp).applyCustomization(conf));
        this.loader = new GremlinGroovyClassLoader(this.getParentLoader(), conf);
    }

    private Object callGlobal(String name, Object[] args) {
        return this.callGlobal(name, args, this.context);
    }

    private Object callGlobal(String name, Object[] args, ScriptContext ctx) {
        Closure closure = this.globalClosures.get(name);
        if (closure != null) {
            return closure.call(args);
        }
        Object value = ctx.getAttribute(name);
        if (value instanceof Closure) {
            return ((Closure)value).call(args);
        }
        throw new MissingMethodException(name, this.getClass(), args);
    }

    private synchronized String generateScriptName() {
        return SCRIPT + scriptNameCounter.incrementAndGet() + DOT_GROOVY;
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (null == clazz || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, m, args) -> this.invokeImpl(obj, m.getName(), args));
    }

    protected ClassLoader getParentLoader() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = ctxtLoader.loadClass(GROOVY_LANG_SCRIPT);
            if (c == Script.class) {
                return ctxtLoader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Script.class.getClassLoader();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private final class GroovyCacheLoader
    implements CacheLoader<String, Future<Class>> {
        private GroovyCacheLoader() {
        }

        @Override
        public Future<Class> load(String script) throws Exception {
            long start = System.currentTimeMillis();
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Class clazz = GremlinGroovyScriptEngine.this.loader.parseClass(script, GremlinGroovyScriptEngine.this.generateScriptName());
                    return clazz;
                }
                catch (CompilationFailedException e) {
                    long finish = System.currentTimeMillis();
                    log.error("Script compilation FAILED {} took {}ms {}", script, finish - start, e);
                    GremlinGroovyScriptEngine.this.failedCompilationCount.incrementAndGet();
                    throw e;
                }
                finally {
                    long time = System.currentTimeMillis() - start;
                    if (time > GremlinGroovyScriptEngine.this.expectedCompilationTime) {
                        log.warn("Script compilation {} took {}ms", (Object)script, (Object)time);
                        GremlinGroovyScriptEngine.this.longRunCompilationCount.incrementAndGet();
                    } else {
                        log.debug("Script compilation {} took {}ms", (Object)script, (Object)time);
                    }
                }
            }, Runnable::run);
        }
    }
}

