/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential;

import java.util.Arrays;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.GremlinDsl;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.mindrot.jbcrypt.BCrypt;

@GremlinDsl(traversalSource="org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialTraversalSourceDsl")
public interface CredentialTraversalDsl<S, E>
extends GraphTraversal.Admin<S, E> {
    public static final int BCRYPT_ROUNDS = 4;

    default public GraphTraversal<S, Vertex> users() {
        return (CredentialTraversal)this.hasLabel("user", new String[0]);
    }

    default public GraphTraversal<S, Vertex> users(String username, String ... more) {
        if (more.length == 0) {
            return (CredentialTraversal)this.has("user", "username", username);
        }
        int lastIndex = more.length;
        String[] usernames = Arrays.copyOf(more, lastIndex + 1);
        usernames[lastIndex] = username;
        return (CredentialTraversal)this.has("user", "username", P.within(usernames));
    }

    default public GraphTraversal<S, Vertex> user(String username, String password) {
        return this.has("user", "username", username).fold().coalesce(__.unfold(), __.addV("user").property("username", (Object)username, new Object[0])).property("password", (Object)BCrypt.hashpw(password, BCrypt.gensalt(4)), new Object[0]);
    }
}

