/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.util.Collection;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONTypeDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONTypeSerializerV2d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONTypeSerializerV3d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationConfig;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationConfig;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.NamedType;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.impl.StdTypeResolverBuilder;

public class GraphSONTypeResolverBuilder
extends StdTypeResolverBuilder {
    private TypeInfo typeInfo;
    private String valuePropertyName;
    private final GraphSONVersion version;

    public GraphSONTypeResolverBuilder(GraphSONVersion version) {
        this.version = version;
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, false, true);
        return new GraphSONTypeDeserializer(baseType, idRes, this.getTypeProperty(), this.typeInfo, this.valuePropertyName);
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, true, false);
        return this.version == GraphSONVersion.V2_0 ? new GraphSONTypeSerializerV2d0(idRes, this.getTypeProperty(), this.typeInfo, this.valuePropertyName) : new GraphSONTypeSerializerV3d0(idRes, this.getTypeProperty(), this.typeInfo, this.valuePropertyName);
    }

    public GraphSONTypeResolverBuilder valuePropertyName(String valuePropertyName) {
        this.valuePropertyName = valuePropertyName;
        return this;
    }

    public GraphSONTypeResolverBuilder typesEmbedding(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
        return this;
    }
}

