/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService;
import org.apache.tinkerpop.gremlin.util.SystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoShimServiceLoader {
    private static volatile KryoShimService cachedShimService;
    private static volatile Configuration configuration;
    private static final String maskedProperties = ".+\\.(password|keyStorePassword|trustStorePassword)|spark.authenticate.secret";
    private static final Logger log;
    public static final String KRYO_SHIM_SERVICE = "gremlin.io.kryoShimService";

    public static void applyConfiguration(Configuration configuration) {
        if (null == KryoShimServiceLoader.configuration || null == cachedShimService || !KryoShimServiceLoader.configuration.getKeys().hasNext()) {
            KryoShimServiceLoader.configuration = configuration;
            KryoShimServiceLoader.load(true);
        }
    }

    public static void close() {
        if (null != cachedShimService) {
            cachedShimService.close();
        }
        cachedShimService = null;
        configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KryoShimService load(boolean forceReload) {
        if (null != cachedShimService && !forceReload) {
            return cachedShimService;
        }
        if (null != cachedShimService) {
            cachedShimService.close();
        }
        if (null == configuration) {
            configuration = SystemUtil.getSystemPropertiesConfiguration("tinkerpop", true);
        }
        ArrayList<KryoShimService> services = new ArrayList<KryoShimService>();
        ServiceLoader<KryoShimService> serviceLoader = ServiceLoader.load(KryoShimService.class);
        Iterator iterator = KryoShimServiceLoader.class;
        synchronized (KryoShimServiceLoader.class) {
            if (forceReload) {
                serviceLoader.reload();
            }
            for (KryoShimService kss : serviceLoader) {
                services.add(kss);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (configuration.containsKey(KRYO_SHIM_SERVICE)) {
                for (KryoShimService kss : services) {
                    if (!kss.getClass().getCanonicalName().equals(configuration.getString(KRYO_SHIM_SERVICE))) continue;
                    log.info("Set KryoShimService to {} because of configuration {}={}", kss.getClass().getSimpleName(), KRYO_SHIM_SERVICE, configuration.getString(KRYO_SHIM_SERVICE));
                    cachedShimService = kss;
                    break;
                }
            } else {
                services.sort(KryoShimServiceComparator.INSTANCE);
                for (KryoShimService kss : services) {
                    log.debug("Found KryoShimService: {} (priority {})", (Object)kss.getClass().getCanonicalName(), (Object)kss.getPriority());
                }
                if (0 != services.size()) {
                    cachedShimService = (KryoShimService)services.get(services.size() - 1);
                    log.info("Set KryoShimService to {} because its priority value ({}) is the best available", (Object)cachedShimService.getClass().getSimpleName(), (Object)cachedShimService.getPriority());
                }
            }
            if (null == cachedShimService) {
                throw new IllegalStateException("Unable to load KryoShimService");
            }
            log.info("Configuring KryoShimService {} with the following configuration:\n#######START########\n{}\n########END#########", (Object)cachedShimService.getClass().getCanonicalName(), (Object)ConfigurationUtils.toString(KryoShimServiceLoader.maskedConfiguration(configuration)));
            cachedShimService.applyConfiguration(configuration);
            return cachedShimService;
        }
    }

    private static Configuration maskedConfiguration(Configuration configuration) {
        BaseConfiguration maskedConfiguration = new BaseConfiguration();
        Iterator<String> keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (key.matches(maskedProperties)) {
                maskedConfiguration.setProperty(key, "******");
                continue;
            }
            maskedConfiguration.setProperty(key, configuration.getProperty(key));
        }
        return maskedConfiguration;
    }

    public static byte[] writeClassAndObjectToBytes(Object object) {
        KryoShimService shimService = KryoShimServiceLoader.load(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        shimService.writeClassAndObject(object, baos);
        return baos.toByteArray();
    }

    public static <T> T readClassAndObject(InputStream inputStream) {
        KryoShimService shimService = KryoShimServiceLoader.load(false);
        return (T)shimService.readClassAndObject(inputStream);
    }

    static {
        log = LoggerFactory.getLogger(KryoShimServiceLoader.class);
    }

    private static enum KryoShimServiceComparator implements Comparator<KryoShimService>
    {
        INSTANCE;


        @Override
        public int compare(KryoShimService a, KryoShimService b) {
            int bp;
            int ap = a.getPriority();
            if (ap < (bp = b.getPriority())) {
                return -1;
            }
            if (bp < ap) {
                return 1;
            }
            int result = a.getClass().getCanonicalName().compareTo(b.getClass().getCanonicalName());
            if (0 == result) {
                log.warn("Found two {} implementations with the same canonical classname: {}.  This may indicate a problem with the classpath/classloader such as duplicate or conflicting copies of the file META-INF/services/org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService.", (Object)a.getClass().getCanonicalName());
            } else {
                String winner = 0 < result ? a.getClass().getCanonicalName() : b.getClass().getCanonicalName();
                log.warn("{} implementations {} and {} are tied with priority value {}.  Preferring {} to the other because it has a lexicographically greater classname.  Consider setting the system property \"{}\" instead of relying on priority tie-breaking.", KryoShimService.class.getSimpleName(), a, b, ap, winner, KryoShimServiceLoader.KRYO_SHIM_SERVICE);
            }
            return result;
        }
    }
}

