/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import com.google.common.base.Preconditions;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.graphdb.types.ParameterType;

public enum Mapping {
    DEFAULT,
    TEXT,
    STRING,
    TEXTSTRING,
    PREFIX_TREE;


    public Parameter asParameter() {
        return ParameterType.MAPPING.getParameter(this);
    }

    public static Mapping getMapping(KeyInformation information) {
        Object value = ParameterType.MAPPING.findParameter(information.getParameters(), null);
        if (value == null) {
            return DEFAULT;
        }
        Preconditions.checkArgument(value instanceof Mapping || value instanceof String, "Invalid mapping specified: %s", new Object[]{value});
        if (value instanceof String) {
            value = Mapping.valueOf(value.toString().toUpperCase());
        }
        return (Mapping)((Object)value);
    }

    public static Mapping getMapping(String store, String key, KeyInformation.IndexRetriever information) {
        KeyInformation ki = information.get(store, key);
        Preconditions.checkNotNull(ki, "Could not find key information for: %s", new Object[]{key});
        return Mapping.getMapping(ki);
    }
}

