/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.database.StandardJanusGraph;

public class ManagementUtil {
    public static void awaitGraphIndexUpdate(JanusGraph g, String indexName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, null, time, unit);
    }

    public static void awaitVertexIndexUpdate(JanusGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, relationTypeName, time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awaitIndexUpdate(JanusGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        Preconditions.checkArgument(g != null && g.isOpen(), "Need to provide valid, open graph instance");
        Preconditions.checkArgument(time > 0L && unit != null, "Need to provide valid time interval");
        Preconditions.checkArgument(StringUtils.isNotBlank(indexName), "Need to provide an index name");
        StandardJanusGraph graph = (StandardJanusGraph)g;
        TimestampProvider times = graph.getConfiguration().getTimestampProvider();
        Instant end = times.getTime().plus(Duration.of(time, unit));
        boolean isStable = false;
        while (times.getTime().isBefore(end)) {
            JanusGraphManagement management = graph.openManagement();
            try {
                Index idx;
                if (StringUtils.isNotBlank(relationTypeName)) {
                    idx = management.getRelationIndex(management.getRelationType(relationTypeName), indexName);
                    Preconditions.checkNotNull(idx, "Index could not be found: %s @ %s", new Object[]{indexName, relationTypeName});
                    isStable = idx.getIndexStatus().isStable();
                } else {
                    idx = management.getGraphIndex(indexName);
                    Preconditions.checkNotNull(idx, "Index could not be found: %s", new Object[]{indexName});
                    isStable = true;
                    for (PropertyKey key : idx.getFieldKeys()) {
                        if (idx.getIndexStatus(key).isStable()) continue;
                        isStable = false;
                    }
                }
            }
            finally {
                management.rollback();
            }
            if (isStable) break;
            try {
                times.sleepFor(Duration.ofMillis(500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!isStable) {
            throw new JanusGraphException("Index did not stabilize within the given amount of time. For sufficiently long wait periods this is most likely caused by a failed/incorrectly shut down JanusGraph instance or a lingering transaction.");
        }
    }
}

