/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.function.Function;
import org.janusgraph.util.encoding.StringEncoding;

public enum EntryMetaData {
    TTL(Integer.class, false, data -> data instanceof Integer && (long)((Integer)data).intValue() >= 0L),
    VISIBILITY(String.class, true, data -> data instanceof String && StringEncoding.isAsciiString((String)data)),
    TIMESTAMP(Long.class, false, data -> data instanceof Long);

    public static final java.util.Map<EntryMetaData, Object> EMPTY_METADATA;
    private final Class<?> dataType;
    private final boolean identifying;
    private final Function<Object, Boolean> validator;

    private EntryMetaData(Class<?> dataType, boolean identifying, Function<Object, Boolean> validator) {
        this.dataType = dataType;
        this.identifying = identifying;
        this.validator = validator;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public boolean isValidData(Object datum) {
        Preconditions.checkNotNull(datum);
        return this.validator.apply(datum);
    }

    static {
        EMPTY_METADATA = ImmutableMap.of();
    }

    public static class Map
    extends EnumMap<EntryMetaData, Object> {
        public Map() {
            super(EntryMetaData.class);
        }

        @Override
        public Object put(EntryMetaData key, Object value) {
            Preconditions.checkArgument(key.isValidData(value), "Invalid meta data [%s] for [%s]", new Object[]{value, key});
            return super.put(key, value);
        }
    }
}

