/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.janusgraph.core.util.ReflectiveConfigOptionLoader;
import org.janusgraph.diskstorage.configuration.ConfigElement;

public class ConfigNamespace
extends ConfigElement {
    private final boolean isUmbrella;
    private final Map<String, ConfigElement> children = Maps.newHashMap();

    public ConfigNamespace(ConfigNamespace parent, String name, String description, boolean isUmbrella) {
        super(parent, name, description);
        this.isUmbrella = isUmbrella;
    }

    public ConfigNamespace(ConfigNamespace parent, String name, String description) {
        this(parent, name, description, false);
    }

    public boolean isUmbrella() {
        return this.isUmbrella;
    }

    public boolean hasUmbrella() {
        return this.isUmbrella() || !this.isRoot() && this.getNamespace().hasUmbrella();
    }

    @Override
    public boolean isOption() {
        return false;
    }

    void registerChild(ConfigElement element) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument(element.getNamespace() == this, "Configuration element registered with wrong namespace");
        Preconditions.checkArgument(!this.children.containsKey(element.getName()), "A configuration element with the same name has already been added to this namespace: %s", new Object[]{element.getName()});
        this.children.put(element.getName(), element);
    }

    public Iterable<ConfigElement> getChildren() {
        return this.children.values();
    }

    public ConfigElement getChild(String name) {
        ConfigElement child = this.children.get(name);
        if (null != child) {
            return child;
        }
        ReflectiveConfigOptionLoader.INSTANCE.loadStandard(this.getClass());
        child = this.children.get(name);
        if (null != child) {
            return child;
        }
        ReflectiveConfigOptionLoader.INSTANCE.loadAll(this.getClass());
        child = this.children.get(name);
        return child;
    }
}

