/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.janusgraph.diskstorage.configuration.AbstractConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;

public class MixedConfiguration
extends AbstractConfiguration {
    private final ReadConfiguration global;
    private final ReadConfiguration local;

    public MixedConfiguration(ConfigNamespace root, ReadConfiguration global, ReadConfiguration local) {
        super(root);
        Preconditions.checkNotNull(global);
        Preconditions.checkNotNull(local);
        this.global = global;
        this.local = local;
    }

    @Override
    public boolean has(ConfigOption option, String ... umbrellaElements) {
        String key = super.getPath(option, umbrellaElements);
        return option.isLocal() && this.local.get(key, option.getDatatype()) != null || option.isGlobal() && this.global.get(key, option.getDatatype()) != null;
    }

    @Override
    public <O> O get(ConfigOption<O> option, String ... umbrellaElements) {
        String key = super.getPath(option, umbrellaElements);
        Object result = null;
        if (option.isLocal()) {
            result = this.local.get(key, option.getDatatype());
        }
        if (result == null && option.isGlobal()) {
            result = this.global.get(key, option.getDatatype());
        }
        return option.get(result);
    }

    @Override
    public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
        return Arrays.stream(new ReadConfiguration[]{this.global, this.local}).map(config -> super.getContainedNamespaces((ReadConfiguration)config, umbrella, umbrellaElements)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
        HashMap<String, Object> result = Maps.newHashMap();
        for (ReadConfiguration config : new ReadConfiguration[]{this.global, this.local}) {
            result.putAll(super.getSubset(config, umbrella, umbrellaElements));
        }
        return result;
    }

    @Override
    public Configuration restrictTo(String ... umbrellaElements) {
        return MixedConfiguration.restrictTo(this, umbrellaElements);
    }

    @Override
    public void close() {
        this.global.close();
        this.local.close();
    }
}

