/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration.builder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.KCVSConfiguration;
import org.janusgraph.diskstorage.configuration.backend.builder.KCVSConfigurationBuilder;
import org.janusgraph.diskstorage.configuration.builder.ModifiableConfigurationBuilder;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;
import org.janusgraph.graphdb.configuration.validator.CompatibilityValidator;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.util.system.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfigurationBuilder {
    private static final Logger log = LoggerFactory.getLogger(ReadConfigurationBuilder.class);
    static final String BACKLEVEL_STORAGE_VERSION_EXCEPTION = "The storage version on the client or server is lower than the storage version of the graph: graph storage version %s vs. client storage version %s when opening graph %s.";
    static final String INCOMPATIBLE_STORAGE_VERSION_EXCEPTION = "Storage version is incompatible with current client: graph storage version %s vs. client storage version %s when opening graph %s.";

    public ReadConfiguration buildGlobalConfiguration(ReadConfiguration localConfig, BasicConfiguration localBasicConfiguration, ModifiableConfiguration overwrite, KeyColumnValueStoreManager storeManager, ModifiableConfigurationBuilder modifiableConfigurationBuilder, KCVSConfigurationBuilder kcvsConfigurationBuilder) {
        try (KCVSConfiguration keyColumnValueStoreConfiguration = kcvsConfigurationBuilder.buildStandaloneGlobalConfiguration(storeManager, localBasicConfiguration);){
            ModifiableConfiguration globalWrite;
            if (!localBasicConfiguration.has(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, new String[0])) {
                overwrite.set(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, storeManager.getName(), new String[0]);
            }
            if (!(globalWrite = modifiableConfigurationBuilder.buildGlobalWrite(keyColumnValueStoreConfiguration)).isFrozen()) {
                globalWrite.setAll(this.getGlobalSubset(localBasicConfiguration.getAll()));
                this.setupJanusGraphVersion(globalWrite);
                this.setupStorageVersion(globalWrite);
                this.setupTimestampProvider(globalWrite, localBasicConfiguration, storeManager);
                globalWrite.freezeConfiguration();
            } else {
                String graphName = localConfig.get(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot(), String.class);
                boolean upgradeAllowed = this.isUpgradeAllowed(globalWrite, localBasicConfiguration);
                if (upgradeAllowed) {
                    this.setupUpgradeConfiguration(graphName, globalWrite);
                } else {
                    this.checkJanusGraphStorageVersionEquality(globalWrite, graphName);
                }
                this.checkJanusGraphVersion(globalWrite, localBasicConfiguration, keyColumnValueStoreConfiguration, overwrite);
                this.checkOptionsWithDiscrepancies(globalWrite, localBasicConfiguration, overwrite);
            }
            ReadConfiguration readConfiguration = keyColumnValueStoreConfiguration.asReadConfiguration();
            return readConfiguration;
        }
    }

    private void setupUpgradeConfiguration(String graphName, ModifiableConfiguration globalWrite) {
        if (!globalWrite.has(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0])) {
            this.janusGraphVersionsWithDisallowedUpgrade(globalWrite);
            log.info("graph.storage-version has been upgraded from 1 to {} and graph.janusgraph-version has been upgraded from {} to {} on graph {}", JanusGraphConstants.STORAGE_VERSION, globalWrite.get(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, new String[0]), JanusGraphConstants.VERSION, graphName);
            return;
        }
        int storageVersion = Integer.parseInt(JanusGraphConstants.STORAGE_VERSION);
        int initialStorageVersion = Integer.parseInt(globalWrite.get(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]));
        if (initialStorageVersion > storageVersion) {
            throw new JanusGraphException(String.format(BACKLEVEL_STORAGE_VERSION_EXCEPTION, globalWrite.get(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]), JanusGraphConstants.STORAGE_VERSION, graphName));
        }
        if (initialStorageVersion < storageVersion) {
            this.janusGraphVersionsWithDisallowedUpgrade(globalWrite);
            log.info("graph.storage-version has been upgraded from {} to {} and graph.janusgraph-version has been upgraded from {} to {} on graph {}", globalWrite.get(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]), JanusGraphConstants.STORAGE_VERSION, globalWrite.get(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, new String[0]), JanusGraphConstants.VERSION, graphName);
        } else {
            log.warn("Warning graph.allow-upgrade is currently set to true on graph {}. Please set graph.allow-upgrade to false in your properties file.", (Object)graphName);
        }
    }

    private void janusGraphVersionsWithDisallowedUpgrade(ModifiableConfiguration globalWrite) {
        globalWrite.set(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, JanusGraphConstants.VERSION, new String[0]);
        globalWrite.set(GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, JanusGraphConstants.VERSION, new String[0]);
        globalWrite.set(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, JanusGraphConstants.STORAGE_VERSION, new String[0]);
        globalWrite.set(GraphDatabaseConfiguration.ALLOW_UPGRADE, false, new String[0]);
    }

    private void setupJanusGraphVersion(ModifiableConfiguration globalWrite) {
        Preconditions.checkArgument(!globalWrite.has(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, new String[0]), "Database has already been initialized but not frozen");
        globalWrite.set(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, JanusGraphConstants.VERSION, new String[0]);
    }

    private void setupStorageVersion(ModifiableConfiguration globalWrite) {
        Preconditions.checkArgument(!globalWrite.has(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]), "Database has already been initialized but not frozen");
        globalWrite.set(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, JanusGraphConstants.STORAGE_VERSION, new String[0]);
    }

    private void setupTimestampProvider(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration, KeyColumnValueStoreManager storeManager) {
        if (!localBasicConfiguration.has(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0])) {
            TimestampProviders backendPreference;
            StoreFeatures f = storeManager.getFeatures();
            if (f.hasTimestamps() && null != (backendPreference = f.getPreferredTimestamps())) {
                globalWrite.set(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, backendPreference, new String[0]);
                log.info("Set timestamps to {} according to storage backend preference", (Object)LoggerUtil.sanitizeAndLaunder(globalWrite.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0])));
            } else {
                globalWrite.set(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, GraphDatabaseConfiguration.TIMESTAMP_PROVIDER.getDefaultValue(), new String[0]);
                log.info("Set default timestamp provider {}", (Object)LoggerUtil.sanitizeAndLaunder(globalWrite.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0])));
            }
        } else {
            log.info("Using configured timestamp provider {}", (Object)localBasicConfiguration.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]));
        }
    }

    private Map<ConfigElement.PathIdentifier, Object> getGlobalSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isGlobal();
        });
    }

    private Map<ConfigElement.PathIdentifier, Object> getManagedSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isManaged();
        });
    }

    private void checkJanusGraphStorageVersionEquality(ModifiableConfiguration globalWrite, String graphName) {
        if (!Objects.equals(globalWrite.get(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]), JanusGraphConstants.STORAGE_VERSION)) {
            String storageVersion = globalWrite.has(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]) ? globalWrite.get(GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, new String[0]) : "1";
            throw new JanusGraphException(String.format(INCOMPATIBLE_STORAGE_VERSION_EXCEPTION, storageVersion, JanusGraphConstants.STORAGE_VERSION, graphName));
        }
    }

    private void checkJanusGraphVersion(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration, KCVSConfiguration keyColumnValueStoreConfiguration, ModifiableConfiguration overwrite) {
        if (globalWrite.get(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, new String[0]) == null) {
            log.info("JanusGraph version has not been initialized");
            CompatibilityValidator.validateBackwardCompatibilityWithTitan(globalWrite.get(GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, new String[0]), localBasicConfiguration.get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]));
            this.setTitanIDStoreNameIfKeystoreNotExists(keyColumnValueStoreConfiguration, overwrite);
        }
    }

    private void setTitanIDStoreNameIfKeystoreNotExists(KCVSConfiguration keyColumnValueStoreConfiguration, ModifiableConfiguration overwrite) {
        boolean keyStoreExists;
        boolean bl = keyStoreExists = keyColumnValueStoreConfiguration.get(GraphDatabaseConfiguration.IDS_STORE_NAME.getName(), GraphDatabaseConfiguration.IDS_STORE_NAME.getDatatype()) != null;
        if (!keyStoreExists) {
            log.info("Setting {} to {} for Titan compatibility", (Object)GraphDatabaseConfiguration.IDS_STORE_NAME.getName(), (Object)"titan_ids");
            overwrite.set(GraphDatabaseConfiguration.IDS_STORE_NAME, "titan_ids", new String[0]);
        }
    }

    private boolean isUpgradeAllowed(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration) {
        if (localBasicConfiguration.has(GraphDatabaseConfiguration.ALLOW_UPGRADE, new String[0])) {
            return localBasicConfiguration.get(GraphDatabaseConfiguration.ALLOW_UPGRADE, new String[0]);
        }
        if (globalWrite.has(GraphDatabaseConfiguration.ALLOW_UPGRADE, new String[0])) {
            return globalWrite.get(GraphDatabaseConfiguration.ALLOW_UPGRADE, new String[0]);
        }
        return GraphDatabaseConfiguration.ALLOW_UPGRADE.getDefaultValue();
    }

    private void checkOptionsWithDiscrepancies(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration, ModifiableConfiguration overwrite) {
        boolean managedOverridesAllowed = this.isManagedOverwritesAllowed(globalWrite, localBasicConfiguration);
        Set<String> optionsWithDiscrepancies = this.getOptionsWithDiscrepancies(globalWrite, localBasicConfiguration, overwrite, managedOverridesAllowed);
        if (optionsWithDiscrepancies.size() > 0 && !managedOverridesAllowed) {
            String template = "Local settings present for one or more globally managed options: [%s].  These options are controlled through the %s interface; local settings have no effect.";
            throw new JanusGraphConfigurationException(String.format("Local settings present for one or more globally managed options: [%s].  These options are controlled through the %s interface; local settings have no effect.", Joiner.on(", ").join(optionsWithDiscrepancies), ManagementSystem.class.getSimpleName()));
        }
    }

    private boolean isManagedOverwritesAllowed(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration) {
        if (localBasicConfiguration.has(GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, new String[0])) {
            return localBasicConfiguration.get(GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, new String[0]);
        }
        if (globalWrite.has(GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, new String[0])) {
            return globalWrite.get(GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, new String[0]);
        }
        return GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getDefaultValue();
    }

    private Set<String> getOptionsWithDiscrepancies(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration, ModifiableConfiguration overwrite, boolean managedOverridesAllowed) {
        HashSet<String> optionsWithDiscrepancies = Sets.newHashSet();
        for (Map.Entry<ConfigElement.PathIdentifier, Object> entry : this.getManagedSubset(localBasicConfiguration.getAll()).entrySet()) {
            boolean match;
            ConfigElement.PathIdentifier pathId = entry.getKey();
            assert (pathId.element.isOption());
            ConfigOption configOption = (ConfigOption)pathId.element;
            Object localValue = entry.getValue();
            Object storeValue = globalWrite.get(configOption, pathId.umbrellaElements);
            if (overwrite.has(configOption, pathId.umbrellaElements)) {
                storeValue = overwrite.get(configOption, pathId.umbrellaElements);
            }
            if (match = Objects.equals(localValue, storeValue)) continue;
            String fullOptionName = ConfigElement.getPath(pathId.element, pathId.umbrellaElements);
            String template = "Local setting {}={} (Type: {}) is overridden by globally managed value ({}).  Use the {} interface instead of the local configuration to control this setting.";
            Object[] replacements = new Object[]{fullOptionName, localValue, configOption.getType(), storeValue, ManagementSystem.class.getSimpleName()};
            if (managedOverridesAllowed) {
                log.warn("Local setting {}={} (Type: {}) is overridden by globally managed value ({}).  Use the {} interface instead of the local configuration to control this setting.", replacements);
            } else {
                log.error("Local setting {}={} (Type: {}) is overridden by globally managed value ({}).  Use the {} interface instead of the local configuration to control this setting.", replacements);
            }
            optionsWithDiscrepancies.add(fullOptionName);
        }
        return optionsWithDiscrepancies;
    }
}

