/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class CQLTransaction
extends AbstractStoreTransaction {
    private final ConsistencyLevel readConsistencyLevel = ConsistencyLevel.valueOf(this.getConfiguration().getCustomOption(CQLConfigOptions.READ_CONSISTENCY));
    private final ConsistencyLevel writeConsistencyLevel = ConsistencyLevel.valueOf(this.getConfiguration().getCustomOption(CQLConfigOptions.WRITE_CONSISTENCY));

    public CQLTransaction(BaseTransactionConfig config) {
        super(config);
    }

    ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    static CQLTransaction getTransaction(StoreTransaction storeTransaction) {
        Preconditions.checkNotNull(storeTransaction);
        Preconditions.checkArgument(storeTransaction instanceof CQLTransaction, "Unexpected transaction type %s", new Object[]{storeTransaction.getClass().getName()});
        return (CQLTransaction)storeTransaction;
    }

    public String toString() {
        return "CQLTransaction@" + Integer.toHexString(this.hashCode()) + "[read=" + (Object)((Object)this.readConsistencyLevel) + ",write=" + (Object)((Object)this.writeConsistencyLevel) + "]";
    }
}

