/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ElasticSearchMutation {
    private final RequestType requestType;
    private final String index;
    private final String type;
    private final String id;
    private final Map source;

    private ElasticSearchMutation(RequestType requestType, String index, String type, String id, Map source) {
        this.requestType = requestType;
        this.index = index;
        this.type = type;
        this.id = id;
        this.source = source;
    }

    public static ElasticSearchMutation createDeleteRequest(String index, String type, String id) {
        return new ElasticSearchMutation(RequestType.DELETE, index, type, id, null);
    }

    public static ElasticSearchMutation createIndexRequest(String index, String type, String id, Map source) {
        return new ElasticSearchMutation(RequestType.INDEX, index, type, id, source);
    }

    public static ElasticSearchMutation createUpdateRequest(String index, String type, String id, Map source) {
        return new ElasticSearchMutation(RequestType.UPDATE, index, type, id, source);
    }

    public static ElasticSearchMutation createUpdateRequest(String index, String type, String id, ImmutableMap.Builder builder, Map upsert) {
        ImmutableMap source = upsert == null ? builder.build() : builder.put("upsert", upsert).build();
        return new ElasticSearchMutation(RequestType.UPDATE, index, type, id, source);
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Map getSource() {
        return this.source;
    }

    public static enum RequestType {
        INDEX,
        UPDATE,
        DELETE;

    }
}

