/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.compat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.es.ElasticSearchRequest;
import org.janusgraph.diskstorage.indexing.IndexFeatures;

public abstract class AbstractESCompat {
    static final Map<String, Object> MATCH_ALL = ImmutableMap.of("match_all", Collections.EMPTY_MAP);

    static IndexFeatures.Builder coreFeatures() {
        return new IndexFeatures.Builder().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(Mapping.TEXT, Mapping.TEXTSTRING, Mapping.STRING).setWildcardField("_all").supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsNanoseconds().supportsCustomAnalyzer().supportNotQueryNormalForm();
    }

    public abstract IndexFeatures getIndexFeatures();

    public Map<String, Object> createKeywordMapping() {
        return ImmutableMap.of("type", "keyword");
    }

    public Map<String, Object> createTextMapping(String textAnalyzer) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().put("type", "text");
        return (textAnalyzer != null ? builder.put("analyzer", textAnalyzer) : builder).build();
    }

    public String scriptLang() {
        return "painless";
    }

    public ImmutableMap.Builder prepareScript(String inline) {
        ImmutableMap<String, String> script = ImmutableMap.of("inline", inline, "lang", this.scriptLang());
        return ImmutableMap.builder().put("script", script);
    }

    public Map<String, Object> prepareQuery(Map<String, Object> query) {
        return query;
    }

    public Map<String, Object> term(String key, Object value) {
        return ImmutableMap.of("term", ImmutableMap.of(key, value));
    }

    public Map<String, Object> contains(String key, List<String> terms) {
        return this.boolMust(terms.stream().map(term -> this.term(key, term)).collect(Collectors.toList()));
    }

    public Map<String, Object> boolMust(List<Map<String, Object>> queries) {
        return queries.size() > 1 ? ImmutableMap.of("bool", ImmutableMap.of("must", queries)) : queries.get(0);
    }

    public Map<String, Object> boolMustNot(Map<String, Object> query) {
        return ImmutableMap.of("bool", ImmutableMap.of("must_not", query));
    }

    public Map<String, Object> boolShould(List<Map<String, Object>> queries) {
        return ImmutableMap.of("bool", ImmutableMap.of("should", queries));
    }

    public Map<String, Object> boolFilter(Map<String, Object> query) {
        return ImmutableMap.of("bool", ImmutableMap.of("must", MATCH_ALL, "filter", query));
    }

    public Map<String, Object> lt(String key, Object value) {
        return ImmutableMap.of("range", ImmutableMap.of(key, ImmutableMap.of("lt", value)));
    }

    public Map<String, Object> lte(String key, Object value) {
        return ImmutableMap.of("range", ImmutableMap.of(key, ImmutableMap.of("lte", value)));
    }

    public Map<String, Object> gt(String key, Object value) {
        return ImmutableMap.of("range", ImmutableMap.of(key, ImmutableMap.of("gt", value)));
    }

    public Map<String, Object> gte(String key, Object value) {
        return ImmutableMap.of("range", ImmutableMap.of(key, ImmutableMap.of("gte", value)));
    }

    public Map<String, Object> prefix(String key, Object value) {
        return ImmutableMap.of("prefix", ImmutableMap.of(key, value));
    }

    public Map<String, Object> regexp(String key, Object value) {
        return ImmutableMap.of("regexp", ImmutableMap.of(key, value));
    }

    public Map<String, Object> match(String key, Object value) {
        return this.match(key, value, null);
    }

    public Map<String, Object> fuzzyMatch(String key, Object value) {
        return this.match(key, value, "AUTO");
    }

    public Map<String, Object> match(String key, Object value, String fuzziness) {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder().put("query", value);
        builder.put("operator", "and");
        if (fuzziness != null) {
            builder.put("fuzziness", fuzziness);
        }
        return ImmutableMap.of("match", ImmutableMap.of(key, builder.build()));
    }

    public Map<String, Object> queryString(Object query) {
        return ImmutableMap.of("query_string", ImmutableMap.of("query", query));
    }

    public Map<String, Object> geoDistance(String key, double lat, double lon, double radius) {
        return this.filter(ImmutableMap.of("geo_distance", ImmutableMap.of("distance", radius + "km", key, ImmutableList.of(Double.valueOf(lon), Double.valueOf(lat)))));
    }

    public Map<String, Object> geoBoundingBox(String key, double minLat, double minLon, double maxLat, double maxLon) {
        return this.filter(ImmutableMap.of("geo_bounding_box", ImmutableMap.of(key, ImmutableMap.of("top_left", ImmutableList.of(Double.valueOf(minLon), Double.valueOf(maxLat)), "bottom_right", ImmutableList.of(Double.valueOf(maxLon), Double.valueOf(minLat))))));
    }

    public Map<String, Object> geoPolygon(String key, List<List<Double>> points) {
        return this.filter(ImmutableMap.of("geo_polygon", ImmutableMap.of(key, ImmutableMap.of("points", points))));
    }

    public Map<String, Object> geoShape(String key, Map<String, Object> geoShape, Geo predicate) {
        String relation = predicate == Geo.INTERSECT ? "intersects" : predicate.name().toLowerCase();
        return this.filter(ImmutableMap.of("geo_shape", ImmutableMap.of(key, ImmutableMap.of("shape", geoShape, "relation", relation))));
    }

    public Map<String, Object> filter(Map<String, Object> query) {
        return this.boolFilter(query);
    }

    public Map<String, Object> createRequestBody(ElasticSearchRequest request, Parameter[] parameters) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        Optional.ofNullable(request.getSize()).ifPresent(parameter -> requestBody.put("size", parameter));
        Optional.ofNullable(request.getFrom()).ifPresent(parameter -> requestBody.put("from", parameter));
        if (!request.getSorts().isEmpty()) {
            requestBody.put("sort", request.getSorts());
        }
        Optional.ofNullable(request.getQuery()).ifPresent(parameter -> requestBody.put("query", parameter));
        Optional.ofNullable(parameters).ifPresent(p -> Arrays.stream(p).forEachOrdered(parameter -> requestBody.put(parameter.key(), parameter.value())));
        return requestBody;
    }
}

