/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.janusgraph.diskstorage.es.rest.util.BasicAuthHttpClientConfigCallback;
import org.janusgraph.diskstorage.es.rest.util.HttpAuthTypes;
import org.janusgraph.diskstorage.es.rest.util.RestClientAuthenticator;
import org.janusgraph.diskstorage.es.rest.util.SSLConfigurationCallback;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientSetup {
    private static final Logger log = LoggerFactory.getLogger(RestClientSetup.class);

    public ElasticSearchClient connect(Configuration config) throws IOException {
        log.debug("Configuring RestClient");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9200;
        String httpScheme = config.get(ElasticSearchIndex.SSL_ENABLED, new String[0]) != false ? "https" : "http";
        for (String host : config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
            String[] hostStringParts = host.split(":");
            String hostname = hostStringParts[0];
            int hostPort = defaultPort;
            if (hostStringParts.length == 2) {
                hostPort = Integer.parseInt(hostStringParts[1]);
            }
            log.debug("Configured remote host: {} : {}", (Object)hostname, (Object)hostPort);
            hosts.add(new HttpHost(hostname, hostPort, httpScheme));
        }
        RestClient rc = this.getRestClient(hosts.toArray(new HttpHost[hosts.size()]), config);
        int scrollKeepAlive = config.get(ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE, new String[0]);
        Preconditions.checkArgument(scrollKeepAlive >= 1, "Scroll keep-alive should be greater than or equal to 1");
        RestElasticSearchClient client = this.getElasticSearchClient(rc, scrollKeepAlive);
        if (config.has(ElasticSearchIndex.BULK_REFRESH, new String[0])) {
            client.setBulkRefresh(config.get(ElasticSearchIndex.BULK_REFRESH, new String[0]));
        }
        return client;
    }

    protected RestClient getRestClient(HttpHost[] hosts, Configuration config) {
        RestClientBuilder.RequestConfigCallback requestConfigCallback;
        RestClientBuilder restClientBuilder = this.getRestClientBuilder(hosts);
        RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback = this.getHttpClientConfigCallback(config);
        if (httpClientConfigCallback != null) {
            restClientBuilder.setHttpClientConfigCallback(httpClientConfigCallback);
        }
        if ((requestConfigCallback = this.getRequestConfigCallback(config)) != null) {
            restClientBuilder.setRequestConfigCallback(requestConfigCallback);
        }
        if (config.has(ElasticSearchIndex.MAX_RETRY_TIMEOUT, new String[0])) {
            restClientBuilder.setMaxRetryTimeoutMillis(config.get(ElasticSearchIndex.MAX_RETRY_TIMEOUT, new String[0]));
        }
        return restClientBuilder.build();
    }

    protected RestClientBuilder getRestClientBuilder(HttpHost[] hosts) {
        return RestClient.builder(hosts);
    }

    protected RestElasticSearchClient getElasticSearchClient(RestClient rc, int scrollKeepAlive) {
        return new RestElasticSearchClient(rc, scrollKeepAlive);
    }

    protected RestClientBuilder.RequestConfigCallback getRequestConfigCallback(Configuration config) {
        return null;
    }

    protected RestClientBuilder.HttpClientConfigCallback getHttpClientConfigCallback(Configuration config) {
        LinkedList<RestClientBuilder.HttpClientConfigCallback> callbackList = new LinkedList<RestClientBuilder.HttpClientConfigCallback>();
        HttpAuthTypes authType = ConfigOption.getEnumValue(config.get(ElasticSearchIndex.ES_HTTP_AUTH_TYPE, new String[0]), HttpAuthTypes.class);
        log.debug("Configuring HTTP(S) authentication type {}", (Object)authType);
        switch (authType) {
            case BASIC: {
                callbackList.add(new BasicAuthHttpClientConfigCallback(config.has(ElasticSearchIndex.ES_HTTP_AUTH_REALM, new String[0]) ? config.get(ElasticSearchIndex.ES_HTTP_AUTH_REALM, new String[0]) : "", config.get(ElasticSearchIndex.ES_HTTP_AUTH_USERNAME, new String[0]), config.get(ElasticSearchIndex.ES_HTTP_AUTH_PASSWORD, new String[0])));
                break;
            }
            case CUSTOM: {
                callbackList.add(this.getCustomAuthenticator(config.get(ElasticSearchIndex.ES_HTTP_AUTHENTICATOR_CLASS, new String[0]), config.get(ElasticSearchIndex.ES_HTTP_AUTHENTICATOR_ARGS, new String[0])));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Authentication type \"" + (Object)((Object)authType) + "\" is not implemented");
            }
        }
        if (config.get(ElasticSearchIndex.SSL_ENABLED, new String[0]).booleanValue()) {
            SSLConfigurationCallback.Builder sslConfCBBuilder = this.getSSLConfigurationCallbackBuilder();
            boolean configureSSL = false;
            if (config.has(ElasticSearchIndex.SSL_TRUSTSTORE_LOCATION, new String[0])) {
                sslConfCBBuilder.withTrustStore(config.get(ElasticSearchIndex.SSL_TRUSTSTORE_LOCATION, new String[0]), config.get(ElasticSearchIndex.SSL_TRUSTSTORE_PASSWORD, new String[0]));
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_KEYSTORE_LOCATION, new String[0])) {
                String keystorePassword = config.get(ElasticSearchIndex.SSL_KEYSTORE_PASSWORD, new String[0]);
                sslConfCBBuilder.withKeyStore(config.get(ElasticSearchIndex.SSL_KEYSTORE_LOCATION, new String[0]), keystorePassword, config.has(ElasticSearchIndex.SSL_KEY_PASSWORD, new String[0]) ? config.get(ElasticSearchIndex.SSL_KEY_PASSWORD, new String[0]) : keystorePassword);
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_DISABLE_HOSTNAME_VERIFICATION, new String[0]) && config.get(ElasticSearchIndex.SSL_DISABLE_HOSTNAME_VERIFICATION, new String[0]).booleanValue()) {
                log.warn("SSL hostname verification is disabled, Elasticsearch HTTPS connections may not be secure");
                sslConfCBBuilder.disableHostNameVerification();
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_ALLOW_SELF_SIGNED_CERTIFICATES, new String[0]) && config.get(ElasticSearchIndex.SSL_ALLOW_SELF_SIGNED_CERTIFICATES, new String[0]).booleanValue()) {
                log.warn("Self-signed SSL certificate support is enabled, Elasticsearch HTTPS connections may not be secure");
                sslConfCBBuilder.allowSelfSignedCertificates();
                configureSSL = true;
            }
            if (configureSSL) {
                callbackList.add(sslConfCBBuilder.build());
            }
        }
        if (callbackList.isEmpty()) {
            return null;
        }
        return httpClientBuilder -> {
            for (RestClientBuilder.HttpClientConfigCallback cb : callbackList) {
                cb.customizeHttpClient(httpClientBuilder);
            }
            return httpClientBuilder;
        };
    }

    protected SSLConfigurationCallback.Builder getSSLConfigurationCallbackBuilder() {
        return SSLConfigurationCallback.Builder.create();
    }

    protected RestClientAuthenticator getCustomAuthenticator(String authClassName, String[] authClassConstructorArgList) {
        RestClientAuthenticator authenticator;
        Preconditions.checkArgument(StringUtils.isNotEmpty(authClassName), "Custom authenticator class name cannot be empty");
        Preconditions.checkNotNull(authClassConstructorArgList, "Custom authenticator class constructor argument list cannot be null");
        try {
            Class<?> c = Class.forName(authClassName);
            Preconditions.checkArgument(RestClientAuthenticator.class.isAssignableFrom(c), "Authenticator class " + authClassName + " must be a subclass of " + RestClientAuthenticator.class.getName());
            Constructor<?> ctr = c.getConstructor(String[].class);
            authenticator = (RestClientAuthenticator)ctr.newInstance(new Object[]{authClassConstructorArgList});
        }
        catch (Exception e) {
            log.error("Unable to instantiate the custom authenticator {} with constructor arguments \"{}\"", authClassName, authClassConstructorArgList, e);
            throw new RuntimeException("Unable to instantiate the custom authenticator", e);
        }
        try {
            authenticator.init();
        }
        catch (IOException e) {
            log.error("Unable to initialize the custom authenticator {} with constructor arguments \"{}\"", authClassName, authClassConstructorArgList, e);
            throw new RuntimeException("Unable to initialize the custom authenticator", e);
        }
        return authenticator;
    }
}

