/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest.util;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClientBuilder;

public class SSLConfigurationCallback
implements RestClientBuilder.HttpClientConfigCallback {
    private final String trustStoreFile;
    private final String trustStorePassword;
    private final String keyStoreFile;
    private final String keyStorePassword;
    private final String keyPassword;
    private final SSLContextBuilder sslContextBuilder;
    private final boolean disableHostNameVerification;
    private final boolean allowSelfSignedCertificates;

    private SSLConfigurationCallback(SSLContextBuilder sslContextBuilder, String trustStoreFile, String trustStorePassword, String keyStoreFile, String keyStorePassword, String keyPassword, boolean disableHostNameVerification, boolean allowSelfSignedCertificates) {
        this.sslContextBuilder = sslContextBuilder;
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassword = trustStorePassword;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = keyStorePassword;
        this.keyPassword = keyPassword;
        this.disableHostNameVerification = disableHostNameVerification;
        this.allowSelfSignedCertificates = allowSelfSignedCertificates;
    }

    @Override
    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
        SSLContext sslcontext;
        TrustSelfSignedStrategy trustStrategy = this.allowSelfSignedCertificates ? new TrustSelfSignedStrategy() : null;
        try {
            if (StringUtils.isNotEmpty(this.trustStoreFile)) {
                this.sslContextBuilder.loadTrustMaterial(new File(this.trustStoreFile), this.trustStorePassword.toCharArray(), (TrustStrategy)trustStrategy);
            } else {
                this.sslContextBuilder.loadTrustMaterial(trustStrategy);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Invalid trust store file " + this.trustStoreFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load trust store data from " + this.trustStoreFile, e);
        }
        try {
            if (StringUtils.isNotEmpty(this.keyStoreFile)) {
                this.sslContextBuilder.loadKeyMaterial(new File(this.keyStoreFile), this.keyStorePassword.toCharArray(), this.keyPassword.toCharArray());
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException("Invalid key store file " + this.keyStoreFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load key store data from " + this.keyStoreFile, e);
        }
        try {
            sslcontext = this.sslContextBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("SSL context initialization failed", e);
        }
        httpClientBuilder.setSSLContext(sslcontext);
        if (this.disableHostNameVerification) {
            httpClientBuilder.setSSLHostnameVerifier(new NoopHostnameVerifier());
        }
        return httpClientBuilder;
    }

    public static class Builder {
        private final SSLContextBuilder sslContextBuilder;
        private String trustStoreFile;
        private String trustStorePassword;
        private String keyStoreFile;
        private String keyStorePassword;
        private String keyPassword;
        private boolean disableHostNameVerification;
        private boolean allowSelfSignedCertificates;

        private Builder(SSLContextBuilder sslContextBuilder) {
            this.sslContextBuilder = sslContextBuilder;
        }

        public static Builder createCustom(SSLContextBuilder sslContextBuilder) {
            return new Builder(sslContextBuilder);
        }

        public static Builder create() {
            return new Builder(SSLContexts.custom());
        }

        public Builder withTrustStore(String trustStoreFile, String trustStorePassword) {
            this.trustStoreFile = trustStoreFile;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder withKeyStore(String keyStoreFile, String keyStorePassword, String keyPassword) {
            this.keyStoreFile = keyStoreFile;
            this.keyStorePassword = keyStorePassword;
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder disableHostNameVerification() {
            this.disableHostNameVerification = true;
            return this;
        }

        public Builder allowSelfSignedCertificates() {
            this.allowSelfSignedCertificates = true;
            return this;
        }

        public SSLConfigurationCallback build() {
            return new SSLConfigurationCallback(this.sslContextBuilder, this.trustStoreFile, this.trustStorePassword, this.keyStoreFile, this.keyStorePassword, this.keyPassword, this.disableHostNameVerification, this.allowSelfSignedCertificates);
        }
    }
}

